@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetPeeringServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peeringServiceName The name of the peering.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPeeringServicePlainArgs(
    public val peeringServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetPeeringServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetPeeringServicePlainArgs =
        com.pulumi.azurenative.peering.inputs.GetPeeringServicePlainArgs.builder()
            .peeringServiceName(peeringServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPeeringServicePlainArgs].
 */
@PulumiTagMarker
public class GetPeeringServicePlainArgsBuilder internal constructor() {
    private var peeringServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the peering.
     */
    @JvmName("dcobwuajlljeuebg")
    public suspend fun peeringServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringServiceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("slcnopwihstfbrhc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPeeringServicePlainArgs = GetPeeringServicePlainArgs(
        peeringServiceName = peeringServiceName ?: throw PulumiNullFieldException("peeringServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
