@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetPrefixPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The properties to be expanded.
 * @property peeringServiceName The name of the peering service.
 * @property prefixName The name of the prefix.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPrefixPlainArgs(
    public val expand: String? = null,
    public val peeringServiceName: String,
    public val prefixName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetPrefixPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetPrefixPlainArgs =
        com.pulumi.azurenative.peering.inputs.GetPrefixPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .peeringServiceName(peeringServiceName.let({ args0 -> args0 }))
            .prefixName(prefixName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrefixPlainArgs].
 */
@PulumiTagMarker
public class GetPrefixPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var peeringServiceName: String? = null

    private var prefixName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The properties to be expanded.
     */
    @JvmName("bmnuicksaugpithd")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the peering service.
     */
    @JvmName("thqmwnlrsijvetvp")
    public suspend fun peeringServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringServiceName = mapped
    }

    /**
     * @param value The name of the prefix.
     */
    @JvmName("kihginuqufgqpjwq")
    public suspend fun prefixName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.prefixName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vdodvwacxvreeeol")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrefixPlainArgs = GetPrefixPlainArgs(
        expand = expand,
        peeringServiceName = peeringServiceName ?: throw PulumiNullFieldException("peeringServiceName"),
        prefixName = prefixName ?: throw PulumiNullFieldException("prefixName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
