@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.GetRegisteredPrefixPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peeringName The name of the peering.
 * @property registeredPrefixName The name of the registered prefix.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetRegisteredPrefixPlainArgs(
    public val peeringName: String,
    public val registeredPrefixName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.GetRegisteredPrefixPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.GetRegisteredPrefixPlainArgs =
        com.pulumi.azurenative.peering.inputs.GetRegisteredPrefixPlainArgs.builder()
            .peeringName(peeringName.let({ args0 -> args0 }))
            .registeredPrefixName(registeredPrefixName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegisteredPrefixPlainArgs].
 */
@PulumiTagMarker
public class GetRegisteredPrefixPlainArgsBuilder internal constructor() {
    private var peeringName: String? = null

    private var registeredPrefixName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the peering.
     */
    @JvmName("arspfsfnvnrvcyev")
    public suspend fun peeringName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peeringName = mapped
    }

    /**
     * @param value The name of the registered prefix.
     */
    @JvmName("uagcocctjegtdcwg")
    public suspend fun registeredPrefixName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registeredPrefixName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xyifiawumfnqtjru")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRegisteredPrefixPlainArgs = GetRegisteredPrefixPlainArgs(
        peeringName = peeringName ?: throw PulumiNullFieldException("peeringName"),
        registeredPrefixName = registeredPrefixName ?: throw
            PulumiNullFieldException("registeredPrefixName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
