@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.inputs

import com.pulumi.azurenative.peering.inputs.PeeringPropertiesDirectArgs.builder
import com.pulumi.azurenative.peering.kotlin.enums.DirectPeeringType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties that define a direct peering.
 * @property connections The set of connections that constitute a direct peering.
 * @property directPeeringType The type of direct peering.
 * @property peerAsn The reference of the peer ASN.
 */
public data class PeeringPropertiesDirectArgs(
    public val connections: Output<List<DirectConnectionArgs>>? = null,
    public val directPeeringType: Output<Either<String, DirectPeeringType>>? = null,
    public val peerAsn: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.peering.inputs.PeeringPropertiesDirectArgs> {
    override fun toJava(): com.pulumi.azurenative.peering.inputs.PeeringPropertiesDirectArgs =
        com.pulumi.azurenative.peering.inputs.PeeringPropertiesDirectArgs.builder()
            .connections(
                connections?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .directPeeringType(
                directPeeringType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .peerAsn(peerAsn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PeeringPropertiesDirectArgs].
 */
@PulumiTagMarker
public class PeeringPropertiesDirectArgsBuilder internal constructor() {
    private var connections: Output<List<DirectConnectionArgs>>? = null

    private var directPeeringType: Output<Either<String, DirectPeeringType>>? = null

    private var peerAsn: Output<SubResourceArgs>? = null

    /**
     * @param value The set of connections that constitute a direct peering.
     */
    @JvmName("eqgawrqqrlmtemmi")
    public suspend fun connections(`value`: Output<List<DirectConnectionArgs>>) {
        this.connections = value
    }

    @JvmName("swocajrjjsluorjq")
    public suspend fun connections(vararg values: Output<DirectConnectionArgs>) {
        this.connections = Output.all(values.asList())
    }

    /**
     * @param values The set of connections that constitute a direct peering.
     */
    @JvmName("cyavgbtoigvlvwym")
    public suspend fun connections(values: List<Output<DirectConnectionArgs>>) {
        this.connections = Output.all(values)
    }

    /**
     * @param value The type of direct peering.
     */
    @JvmName("eagsgpyjaneqsjyy")
    public suspend fun directPeeringType(`value`: Output<Either<String, DirectPeeringType>>) {
        this.directPeeringType = value
    }

    /**
     * @param value The reference of the peer ASN.
     */
    @JvmName("dkiaqgmfrcctwatb")
    public suspend fun peerAsn(`value`: Output<SubResourceArgs>) {
        this.peerAsn = value
    }

    /**
     * @param value The set of connections that constitute a direct peering.
     */
    @JvmName("kxastxwjtjgcqqya")
    public suspend fun connections(`value`: List<DirectConnectionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param argument The set of connections that constitute a direct peering.
     */
    @JvmName("eydywvbffqbqpxkb")
    public suspend fun connections(argument: List<suspend DirectConnectionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DirectConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The set of connections that constitute a direct peering.
     */
    @JvmName("ibwjiphptmitjyqq")
    public suspend fun connections(vararg argument: suspend DirectConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DirectConnectionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param argument The set of connections that constitute a direct peering.
     */
    @JvmName("avdxdbjxtsjxsgvu")
    public suspend fun connections(argument: suspend DirectConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DirectConnectionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.connections = mapped
    }

    /**
     * @param values The set of connections that constitute a direct peering.
     */
    @JvmName("pilfppwvfnvgxpjs")
    public suspend fun connections(vararg values: DirectConnectionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connections = mapped
    }

    /**
     * @param value The type of direct peering.
     */
    @JvmName("evoupsdussjcauis")
    public suspend fun directPeeringType(`value`: Either<String, DirectPeeringType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directPeeringType = mapped
    }

    /**
     * @param value The type of direct peering.
     */
    @JvmName("yvvsubhwcfgdtlux")
    public fun directPeeringType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DirectPeeringType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directPeeringType = mapped
    }

    /**
     * @param value The type of direct peering.
     */
    @JvmName("jveorkmqehnjlifr")
    public fun directPeeringType(`value`: DirectPeeringType) {
        val toBeMapped = Either.ofRight<String, DirectPeeringType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directPeeringType = mapped
    }

    /**
     * @param value The reference of the peer ASN.
     */
    @JvmName("jgbuhpxhairyjgcn")
    public suspend fun peerAsn(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    /**
     * @param argument The reference of the peer ASN.
     */
    @JvmName("eipmanmgwfgtrere")
    public suspend fun peerAsn(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.peerAsn = mapped
    }

    internal fun build(): PeeringPropertiesDirectArgs = PeeringPropertiesDirectArgs(
        connections = connections,
        directPeeringType = directPeeringType,
        peerAsn = peerAsn,
    )
}
