@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The contact detail class.
 * @property email The e-mail address of the contact.
 * @property phone The phone number of the contact.
 * @property role The role of the contact.
 */
public data class ContactDetailResponse(
    public val email: String? = null,
    public val phone: String? = null,
    public val role: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.ContactDetailResponse):
            ContactDetailResponse = ContactDetailResponse(
            email = javaType.email().map({ args0 -> args0 }).orElse(null),
            phone = javaType.phone().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
        )
    }
}
