@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The customer's ASN that is registered by the peering service provider.
 * @property asn The customer's ASN from which traffic originates.
 * @property id The ID of the resource.
 * @property name The name of the resource.
 * @property peeringServicePrefixKey The peering service prefix key that is to be shared with the customer.
 * @property provisioningState The provisioning state of the resource.
 * @property type The type of the resource.
 */
public data class GetRegisteredAsnResult(
    public val asn: Int? = null,
    public val id: String,
    public val name: String,
    public val peeringServicePrefixKey: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.GetRegisteredAsnResult):
            GetRegisteredAsnResult = GetRegisteredAsnResult(
            asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            peeringServicePrefixKey = javaType.peeringServicePrefixKey(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
