@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.peering.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the event associated with a prefix.
 * @property eventDescription The description of the event associated with a prefix.
 * @property eventLevel The level of the event associated with a prefix.
 * @property eventSummary The summary of the event associated with a prefix.
 * @property eventTimestamp The timestamp of the event associated with a prefix.
 * @property eventType The type of the event associated with a prefix.
 */
public data class PeeringServicePrefixEventResponse(
    public val eventDescription: String,
    public val eventLevel: String,
    public val eventSummary: String,
    public val eventTimestamp: String,
    public val eventType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.peering.outputs.PeeringServicePrefixEventResponse):
            PeeringServicePrefixEventResponse = PeeringServicePrefixEventResponse(
            eventDescription = javaType.eventDescription(),
            eventLevel = javaType.eventLevel(),
            eventSummary = javaType.eventSummary(),
            eventTimestamp = javaType.eventTimestamp(),
            eventType = javaType.eventType(),
        )
    }
}
