@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attestationName The name of the attestation.
 * @property resourceId Resource ID.
 */
public data class GetAttestationAtResourcePlainArgs(
    public val attestationName: String,
    public val resourceId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourcePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourcePlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtResourcePlainArgs.builder()
            .attestationName(attestationName.let({ args0 -> args0 }))
            .resourceId(resourceId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttestationAtResourcePlainArgs].
 */
@PulumiTagMarker
public class GetAttestationAtResourcePlainArgsBuilder internal constructor() {
    private var attestationName: String? = null

    private var resourceId: String? = null

    /**
     * @param value The name of the attestation.
     */
    @JvmName("fwhnqjtfftxogutp")
    public suspend fun attestationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attestationName = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("vfobufucecrbiwfi")
    public suspend fun resourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceId = mapped
    }

    internal fun build(): GetAttestationAtResourcePlainArgs = GetAttestationAtResourcePlainArgs(
        attestationName = attestationName ?: throw PulumiNullFieldException("attestationName"),
        resourceId = resourceId ?: throw PulumiNullFieldException("resourceId"),
    )
}
