@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attestationName The name of the attestation.
 */
public data class GetAttestationAtSubscriptionPlainArgs(
    public val attestationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtSubscriptionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtSubscriptionPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetAttestationAtSubscriptionPlainArgs.builder()
            .attestationName(attestationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAttestationAtSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetAttestationAtSubscriptionPlainArgsBuilder internal constructor() {
    private var attestationName: String? = null

    /**
     * @param value The name of the attestation.
     */
    @JvmName("oyrycasddtrowbyq")
    public suspend fun attestationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.attestationName = mapped
    }

    internal fun build(): GetAttestationAtSubscriptionPlainArgs =
        GetAttestationAtSubscriptionPlainArgs(
            attestationName = attestationName ?: throw PulumiNullFieldException("attestationName"),
        )
}
