@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.inputs

import com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourceGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property remediationName The name of the remediation.
 * @property resourceGroupName Resource group name.
 */
public data class GetRemediationAtResourceGroupPlainArgs(
    public val remediationName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourceGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourceGroupPlainArgs =
        com.pulumi.azurenative.policyinsights.inputs.GetRemediationAtResourceGroupPlainArgs.builder()
            .remediationName(remediationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRemediationAtResourceGroupPlainArgs].
 */
@PulumiTagMarker
public class GetRemediationAtResourceGroupPlainArgsBuilder internal constructor() {
    private var remediationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the remediation.
     */
    @JvmName("iijoetqyyakclmvy")
    public suspend fun remediationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.remediationName = mapped
    }

    /**
     * @param value Resource group name.
     */
    @JvmName("iqptvnoyndxfkxdc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRemediationAtResourceGroupPlainArgs =
        GetRemediationAtResourceGroupPlainArgs(
            remediationName = remediationName ?: throw PulumiNullFieldException("remediationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
