@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.policyinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Details of a single deployment created by the remediation.
 * @property createdOn The time at which the remediation was created.
 * @property deploymentId Resource ID of the template deployment that will remediate the resource.
 * @property error Error encountered while remediated the resource.
 * @property lastUpdatedOn The time at which the remediation deployment was last updated.
 * @property remediatedResourceId Resource ID of the resource that is being remediated by the deployment.
 * @property resourceLocation Location of the resource that is being remediated.
 * @property status Status of the remediation deployment.
 */
public data class RemediationDeploymentResponse(
    public val createdOn: String,
    public val deploymentId: String,
    public val error: ErrorDefinitionResponse,
    public val lastUpdatedOn: String,
    public val remediatedResourceId: String,
    public val resourceLocation: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.policyinsights.outputs.RemediationDeploymentResponse):
            RemediationDeploymentResponse = RemediationDeploymentResponse(
            createdOn = javaType.createdOn(),
            deploymentId = javaType.deploymentId(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.policyinsights.kotlin.outputs.ErrorDefinitionResponse.Companion.toKotlin(args0)
            }),
            lastUpdatedOn = javaType.lastUpdatedOn(),
            remediatedResourceId = javaType.remediatedResourceId(),
            resourceLocation = javaType.resourceLocation(),
            status = javaType.status(),
        )
    }
}
