@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.kotlin.outputs.DashboardLensResponse
import com.pulumi.azurenative.portal.kotlin.outputs.DashboardLensResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Dashboard].
 */
@PulumiTagMarker
public class DashboardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DashboardArgs = DashboardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DashboardArgsBuilder.() -> Unit) {
        val builder = DashboardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Dashboard {
        val builtJavaResource = com.pulumi.azurenative.portal.Dashboard(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Dashboard(builtJavaResource)
    }
}

/**
 * The shared dashboard resource definition.
 * Azure REST API version: 2020-09-01-preview. Prior API version in Azure Native 1.x: 2020-09-01-preview.
 * Other available API versions: 2019-01-01-preview.
 * ## Example Usage
 * ### Create or update a Dashboard
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dashboard = new AzureNative.Portal.Dashboard("dashboard", new()
 *     {
 *         DashboardName = "testDashboard",
 *         Lenses = new[]
 *         {
 *             new AzureNative.Portal.Inputs.DashboardLensArgs
 *             {
 *                 Order = 1,
 *                 Parts = new[]
 *                 {
 *                     new AzureNative.Portal.Inputs.DashboardPartsArgs
 *                     {
 *                         Position = new AzureNative.Portal.Inputs.DashboardPartsPositionArgs
 *                         {
 *                             ColSpan = 3,
 *                             RowSpan = 4,
 *                             X = 1,
 *                             Y = 2,
 *                         },
 *                     },
 *                     new AzureNative.Portal.Inputs.DashboardPartsArgs
 *                     {
 *                         Position = new AzureNative.Portal.Inputs.DashboardPartsPositionArgs
 *                         {
 *                             ColSpan = 6,
 *                             RowSpan = 6,
 *                             X = 5,
 *                             Y = 5,
 *                         },
 *                     },
 *                 },
 *             },
 *             new AzureNative.Portal.Inputs.DashboardLensArgs
 *             {
 *                 Order = 2,
 *                 Parts = new() { },
 *             },
 *         },
 *         Location = "eastus",
 *         Metadata =
 *         {
 *             { "metadata", new Dictionary<string, object?>
 *             {
 *                 ["ColSpan"] = 2,
 *                 ["RowSpan"] = 1,
 *                 ["X"] = 4,
 *                 ["Y"] = 3,
 *             } },
 *         },
 *         ResourceGroupName = "testRG",
 *         Tags =
 *         {
 *             { "aKey", "aValue" },
 *             { "anotherKey", "anotherValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/portal/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := portal.NewDashboard(ctx, "dashboard", &portal.DashboardArgs{
 * 			DashboardName: pulumi.String("testDashboard"),
 * 			Lenses: portal.DashboardLensArray{
 * 				&portal.DashboardLensArgs{
 * 					Order: pulumi.Int(1),
 * 					Parts: []portal.DashboardPartsArgs{
 * 						{
 * 							Position: {
 * 								ColSpan: pulumi.Int(3),
 * 								RowSpan: pulumi.Int(4),
 * 								X:       pulumi.Int(1),
 * 								Y:       pulumi.Int(2),
 * 							},
 * 						},
 * 						{
 * 							Position: {
 * 								ColSpan: pulumi.Int(6),
 * 								RowSpan: pulumi.Int(6),
 * 								X:       pulumi.Int(5),
 * 								Y:       pulumi.Int(5),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&portal.DashboardLensArgs{
 * 					Order: pulumi.Int(2),
 * 					Parts: portal.DashboardPartsArray{},
 * 				},
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Metadata: pulumi.Map{
 * 				"metadata": pulumi.Any(map[string]interface{}{
 * 					"ColSpan": 2,
 * 					"RowSpan": 1,
 * 					"X":       4,
 * 					"Y":       3,
 * 				}),
 * 			},
 * 			ResourceGroupName: pulumi.String("testRG"),
 * 			Tags: pulumi.StringMap{
 * 				"aKey":       pulumi.String("aValue"),
 * 				"anotherKey": pulumi.String("anotherValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.portal.Dashboard;
 * import com.pulumi.azurenative.portal.DashboardArgs;
 * import com.pulumi.azurenative.portal.inputs.DashboardLensArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dashboard = new Dashboard("dashboard", DashboardArgs.builder()
 *             .dashboardName("testDashboard")
 *             .lenses(
 *                 DashboardLensArgs.builder()
 *                     .order(1)
 *                     .parts(
 *                         DashboardPartsArgs.builder()
 *                             .position(DashboardPartsPositionArgs.builder()
 *                                 .colSpan(3)
 *                                 .rowSpan(4)
 *                                 .x(1)
 *                                 .y(2)
 *                                 .build())
 *                             .build(),
 *                         DashboardPartsArgs.builder()
 *                             .position(DashboardPartsPositionArgs.builder()
 *                                 .colSpan(6)
 *                                 .rowSpan(6)
 *                                 .x(5)
 *                                 .y(5)
 *                                 .build())
 *                             .build())
 *                     .build(),
 *                 DashboardLensArgs.builder()
 *                     .order(2)
 *                     .parts()
 *                     .build())
 *             .location("eastus")
 *             .metadata(Map.of("metadata", Map.ofEntries(
 *                 Map.entry("ColSpan", 2),
 *                 Map.entry("RowSpan", 1),
 *                 Map.entry("X", 4),
 *                 Map.entry("Y", 3)
 *             )))
 *             .resourceGroupName("testRG")
 *             .tags(Map.ofEntries(
 *                 Map.entry("aKey", "aValue"),
 *                 Map.entry("anotherKey", "anotherValue")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:portal:Dashboard testDashboard /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Portal/dashboards/{dashboardName}
 * ```
 */
public class Dashboard internal constructor(
    override val javaResource: com.pulumi.azurenative.portal.Dashboard,
) : KotlinCustomResource(javaResource, DashboardMapper) {
    /**
     * The dashboard lenses.
     */
    public val lenses: Output<List<DashboardLensResponse>>?
        get() = javaResource.lenses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The dashboard metadata.
     */
    public val metadata: Output<Map<String, Any>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DashboardMapper : ResourceMapper<Dashboard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.portal.Dashboard::class == javaResource::class

    override fun map(javaResource: Resource): Dashboard = Dashboard(
        javaResource as
            com.pulumi.azurenative.portal.Dashboard,
    )
}

/**
 * @see [Dashboard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Dashboard].
 */
public suspend fun dashboard(name: String, block: suspend DashboardResourceBuilder.() -> Unit):
    Dashboard {
    val builder = DashboardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Dashboard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dashboard(name: String): Dashboard {
    val builder = DashboardResourceBuilder()
    builder.name(name)
    return builder.build()
}
