@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin

import com.pulumi.azurenative.portal.PortalFunctions.getConsolePlain
import com.pulumi.azurenative.portal.PortalFunctions.getConsoleWithLocationPlain
import com.pulumi.azurenative.portal.PortalFunctions.getDashboardPlain
import com.pulumi.azurenative.portal.PortalFunctions.getTenantConfigurationPlain
import com.pulumi.azurenative.portal.PortalFunctions.getUserSettingsPlain
import com.pulumi.azurenative.portal.PortalFunctions.getUserSettingsWithLocationPlain
import com.pulumi.azurenative.portal.PortalFunctions.listListTenantConfigurationViolationPlain
import com.pulumi.azurenative.portal.kotlin.inputs.GetConsolePlainArgs
import com.pulumi.azurenative.portal.kotlin.inputs.GetConsolePlainArgsBuilder
import com.pulumi.azurenative.portal.kotlin.inputs.GetConsoleWithLocationPlainArgs
import com.pulumi.azurenative.portal.kotlin.inputs.GetConsoleWithLocationPlainArgsBuilder
import com.pulumi.azurenative.portal.kotlin.inputs.GetDashboardPlainArgs
import com.pulumi.azurenative.portal.kotlin.inputs.GetDashboardPlainArgsBuilder
import com.pulumi.azurenative.portal.kotlin.inputs.GetTenantConfigurationPlainArgs
import com.pulumi.azurenative.portal.kotlin.inputs.GetTenantConfigurationPlainArgsBuilder
import com.pulumi.azurenative.portal.kotlin.inputs.GetUserSettingsPlainArgs
import com.pulumi.azurenative.portal.kotlin.inputs.GetUserSettingsPlainArgsBuilder
import com.pulumi.azurenative.portal.kotlin.inputs.GetUserSettingsWithLocationPlainArgs
import com.pulumi.azurenative.portal.kotlin.inputs.GetUserSettingsWithLocationPlainArgsBuilder
import com.pulumi.azurenative.portal.kotlin.outputs.GetConsoleResult
import com.pulumi.azurenative.portal.kotlin.outputs.GetConsoleWithLocationResult
import com.pulumi.azurenative.portal.kotlin.outputs.GetDashboardResult
import com.pulumi.azurenative.portal.kotlin.outputs.GetTenantConfigurationResult
import com.pulumi.azurenative.portal.kotlin.outputs.GetUserSettingsResult
import com.pulumi.azurenative.portal.kotlin.outputs.GetUserSettingsWithLocationResult
import com.pulumi.azurenative.portal.kotlin.outputs.ListListTenantConfigurationViolationResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.portal.kotlin.outputs.GetConsoleResult.Companion.toKotlin as getConsoleResultToKotlin
import com.pulumi.azurenative.portal.kotlin.outputs.GetConsoleWithLocationResult.Companion.toKotlin as getConsoleWithLocationResultToKotlin
import com.pulumi.azurenative.portal.kotlin.outputs.GetDashboardResult.Companion.toKotlin as getDashboardResultToKotlin
import com.pulumi.azurenative.portal.kotlin.outputs.GetTenantConfigurationResult.Companion.toKotlin as getTenantConfigurationResultToKotlin
import com.pulumi.azurenative.portal.kotlin.outputs.GetUserSettingsResult.Companion.toKotlin as getUserSettingsResultToKotlin
import com.pulumi.azurenative.portal.kotlin.outputs.GetUserSettingsWithLocationResult.Companion.toKotlin as getUserSettingsWithLocationResultToKotlin
import com.pulumi.azurenative.portal.kotlin.outputs.ListListTenantConfigurationViolationResult.Companion.toKotlin as listListTenantConfigurationViolationResultToKotlin

public object PortalFunctions {
    /**
     * Gets the console for the user.
     * Azure REST API version: 2018-10-01.
     * @param argument null
     * @return Cloud shell console
     */
    public suspend fun getConsole(argument: GetConsolePlainArgs): GetConsoleResult =
        getConsoleResultToKotlin(getConsolePlain(argument.toJava()).await())

    /**
     * @see [getConsole].
     * @param consoleName The name of the console
     * @return Cloud shell console
     */
    public suspend fun getConsole(consoleName: String): GetConsoleResult {
        val argument = GetConsolePlainArgs(
            consoleName = consoleName,
        )
        return getConsoleResultToKotlin(getConsolePlain(argument.toJava()).await())
    }

    /**
     * @see [getConsole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;portal&#46;kotlin&#46;inputs&#46;GetConsolePlainArgs].
     * @return Cloud shell console
     */
    public suspend fun getConsole(argument: suspend GetConsolePlainArgsBuilder.() -> Unit):
        GetConsoleResult {
        val builder = GetConsolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConsoleResultToKotlin(getConsolePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the console for the user.
     * Azure REST API version: 2018-10-01.
     * @param argument null
     * @return Cloud shell console
     */
    public suspend fun getConsoleWithLocation(argument: GetConsoleWithLocationPlainArgs):
        GetConsoleWithLocationResult =
        getConsoleWithLocationResultToKotlin(getConsoleWithLocationPlain(argument.toJava()).await())

    /**
     * @see [getConsoleWithLocation].
     * @param consoleName The name of the console
     * @param location The provider location
     * @return Cloud shell console
     */
    public suspend fun getConsoleWithLocation(consoleName: String, location: String):
        GetConsoleWithLocationResult {
        val argument = GetConsoleWithLocationPlainArgs(
            consoleName = consoleName,
            location = location,
        )
        return getConsoleWithLocationResultToKotlin(getConsoleWithLocationPlain(argument.toJava()).await())
    }

    /**
     * @see [getConsoleWithLocation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;portal&#46;kotlin&#46;inputs&#46;GetConsoleWithLocationPlainArgs].
     * @return Cloud shell console
     */
    public suspend
    fun getConsoleWithLocation(argument: suspend GetConsoleWithLocationPlainArgsBuilder.() -> Unit):
        GetConsoleWithLocationResult {
        val builder = GetConsoleWithLocationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConsoleWithLocationResultToKotlin(getConsoleWithLocationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the Dashboard.
     * Azure REST API version: 2020-09-01-preview.
     * Other available API versions: 2019-01-01-preview.
     * @param argument null
     * @return The shared dashboard resource definition.
     */
    public suspend fun getDashboard(argument: GetDashboardPlainArgs): GetDashboardResult =
        getDashboardResultToKotlin(getDashboardPlain(argument.toJava()).await())

    /**
     * @see [getDashboard].
     * @param dashboardName The name of the dashboard.
     * @param resourceGroupName The name of the resource group.
     * @return The shared dashboard resource definition.
     */
    public suspend fun getDashboard(dashboardName: String, resourceGroupName: String):
        GetDashboardResult {
        val argument = GetDashboardPlainArgs(
            dashboardName = dashboardName,
            resourceGroupName = resourceGroupName,
        )
        return getDashboardResultToKotlin(getDashboardPlain(argument.toJava()).await())
    }

    /**
     * @see [getDashboard].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;portal&#46;kotlin&#46;inputs&#46;GetDashboardPlainArgs].
     * @return The shared dashboard resource definition.
     */
    public suspend fun getDashboard(argument: suspend GetDashboardPlainArgsBuilder.() -> Unit):
        GetDashboardResult {
        val builder = GetDashboardPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDashboardResultToKotlin(getDashboardPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the tenant configuration.
     * Azure REST API version: 2020-09-01-preview.
     * @param argument null
     * @return Tenant configuration.
     */
    public suspend fun getTenantConfiguration(argument: GetTenantConfigurationPlainArgs):
        GetTenantConfigurationResult =
        getTenantConfigurationResultToKotlin(getTenantConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getTenantConfiguration].
     * @param configurationName The configuration name. Value must be 'default'
     * @return Tenant configuration.
     */
    public suspend fun getTenantConfiguration(configurationName: String):
        GetTenantConfigurationResult {
        val argument = GetTenantConfigurationPlainArgs(
            configurationName = configurationName,
        )
        return getTenantConfigurationResultToKotlin(getTenantConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getTenantConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;portal&#46;kotlin&#46;inputs&#46;GetTenantConfigurationPlainArgs].
     * @return Tenant configuration.
     */
    public suspend
    fun getTenantConfiguration(argument: suspend GetTenantConfigurationPlainArgsBuilder.() -> Unit):
        GetTenantConfigurationResult {
        val builder = GetTenantConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTenantConfigurationResultToKotlin(getTenantConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get current user settings for current signed in user. This operation returns settings for the user's cloud shell preferences including preferred location, storage profile, shell type, font and size settings.
     * Azure REST API version: 2018-10-01.
     * @param argument null
     * @return Response to get user settings
     */
    public suspend fun getUserSettings(argument: GetUserSettingsPlainArgs): GetUserSettingsResult =
        getUserSettingsResultToKotlin(getUserSettingsPlain(argument.toJava()).await())

    /**
     * @see [getUserSettings].
     * @param userSettingsName The name of the user settings
     * @return Response to get user settings
     */
    public suspend fun getUserSettings(userSettingsName: String): GetUserSettingsResult {
        val argument = GetUserSettingsPlainArgs(
            userSettingsName = userSettingsName,
        )
        return getUserSettingsResultToKotlin(getUserSettingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserSettings].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;portal&#46;kotlin&#46;inputs&#46;GetUserSettingsPlainArgs].
     * @return Response to get user settings
     */
    public suspend fun getUserSettings(argument: suspend GetUserSettingsPlainArgsBuilder.() -> Unit):
        GetUserSettingsResult {
        val builder = GetUserSettingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserSettingsResultToKotlin(getUserSettingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get current user settings for current signed in user. This operation returns settings for the user's cloud shell preferences including preferred location, storage profile, shell type, font and size settings.
     * Azure REST API version: 2018-10-01.
     * @param argument null
     * @return Response to get user settings
     */
    public suspend fun getUserSettingsWithLocation(argument: GetUserSettingsWithLocationPlainArgs):
        GetUserSettingsWithLocationResult =
        getUserSettingsWithLocationResultToKotlin(getUserSettingsWithLocationPlain(argument.toJava()).await())

    /**
     * @see [getUserSettingsWithLocation].
     * @param location The provider location
     * @param userSettingsName The name of the user settings
     * @return Response to get user settings
     */
    public suspend fun getUserSettingsWithLocation(location: String, userSettingsName: String):
        GetUserSettingsWithLocationResult {
        val argument = GetUserSettingsWithLocationPlainArgs(
            location = location,
            userSettingsName = userSettingsName,
        )
        return getUserSettingsWithLocationResultToKotlin(getUserSettingsWithLocationPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserSettingsWithLocation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;portal&#46;kotlin&#46;inputs&#46;GetUserSettingsWithLocationPlainArgs].
     * @return Response to get user settings
     */
    public suspend
    fun getUserSettingsWithLocation(argument: suspend GetUserSettingsWithLocationPlainArgsBuilder.() -> Unit):
        GetUserSettingsWithLocationResult {
        val builder = GetUserSettingsWithLocationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserSettingsWithLocationResultToKotlin(getUserSettingsWithLocationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets list of items that violate tenant's configuration.
     * Azure REST API version: 2020-09-01-preview.
     * @param argument null
     * @return List of list of items that violate tenant's configuration.
     */
    public suspend fun listListTenantConfigurationViolation():
        ListListTenantConfigurationViolationResult =
        listListTenantConfigurationViolationResultToKotlin(listListTenantConfigurationViolationPlain().await())
}
