@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The operating system type of the cloud shell. Deprecated, use preferredShellType.
 */
public enum class OsType(
    public val javaValue: com.pulumi.azurenative.portal.enums.OsType,
) : ConvertibleToJava<com.pulumi.azurenative.portal.enums.OsType> {
    Windows(com.pulumi.azurenative.portal.enums.OsType.Windows),
    Linux(com.pulumi.azurenative.portal.enums.OsType.Linux),
    ;

    override fun toJava(): com.pulumi.azurenative.portal.enums.OsType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.portal.enums.OsType): OsType =
            OsType.values().first { it.javaValue == javaType }
    }
}
