@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.ConsoleCreatePropertiesArgs.builder
import com.pulumi.azurenative.portal.kotlin.enums.OsType
import com.pulumi.azurenative.portal.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cloud shell properties for creating a console.
 * @property osType The operating system type of the cloud shell.
 * @property provisioningState Provisioning state of the console.
 * @property uri Uri of the console.
 */
public data class ConsoleCreatePropertiesArgs(
    public val osType: Output<Either<String, OsType>>,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.ConsoleCreatePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.ConsoleCreatePropertiesArgs =
        com.pulumi.azurenative.portal.inputs.ConsoleCreatePropertiesArgs.builder()
            .osType(
                osType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConsoleCreatePropertiesArgs].
 */
@PulumiTagMarker
public class ConsoleCreatePropertiesArgsBuilder internal constructor() {
    private var osType: Output<Either<String, OsType>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The operating system type of the cloud shell.
     */
    @JvmName("mkeojybnrnovbnkq")
    public suspend fun osType(`value`: Output<Either<String, OsType>>) {
        this.osType = value
    }

    /**
     * @param value Provisioning state of the console.
     */
    @JvmName("nbyceawxauanegxb")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Uri of the console.
     */
    @JvmName("iijcvyjigmaawhlg")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The operating system type of the cloud shell.
     */
    @JvmName("xmaaedaderxhscbc")
    public suspend fun osType(`value`: Either<String, OsType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operating system type of the cloud shell.
     */
    @JvmName("hnwxdmddhcsaroys")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The operating system type of the cloud shell.
     */
    @JvmName("kqjrwcunhpxpqcal")
    public fun osType(`value`: OsType) {
        val toBeMapped = Either.ofRight<String, OsType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Provisioning state of the console.
     */
    @JvmName("wwtgebgpjxeltinb")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the console.
     */
    @JvmName("ixkfceafshnbdxpd")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the console.
     */
    @JvmName("ehmavrpswddwrhmb")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Uri of the console.
     */
    @JvmName("kaljevfnfppsinph")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ConsoleCreatePropertiesArgs = ConsoleCreatePropertiesArgs(
        osType = osType ?: throw PulumiNullFieldException("osType"),
        provisioningState = provisioningState,
        uri = uri,
    )
}
