@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.GetTenantConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationName The configuration name. Value must be 'default'
 */
public data class GetTenantConfigurationPlainArgs(
    public val configurationName: String,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.GetTenantConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.portal.inputs.GetTenantConfigurationPlainArgs =
        com.pulumi.azurenative.portal.inputs.GetTenantConfigurationPlainArgs.builder()
            .configurationName(configurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTenantConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetTenantConfigurationPlainArgsBuilder internal constructor() {
    private var configurationName: String? = null

    /**
     * @param value The configuration name. Value must be 'default'
     */
    @JvmName("xkfktumwxscsqjxs")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    internal fun build(): GetTenantConfigurationPlainArgs = GetTenantConfigurationPlainArgs(
        configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
    )
}
