@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.inputs

import com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The setting of the content of markdown part.
 * @property content The content of the markdown part.
 * @property markdownSource The source of the content of the markdown part.
 * @property markdownUri The uri of markdown content.
 * @property subtitle The subtitle of the markdown part.
 * @property title The title of the markdown part.
 */
public data class MarkdownPartMetadataSettingsSettingsArgs(
    public val content: Output<String>? = null,
    public val markdownSource: Output<Int>? = null,
    public val markdownUri: Output<String>? = null,
    public val subtitle: Output<String>? = null,
    public val title: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsSettingsArgs =
        com.pulumi.azurenative.portal.inputs.MarkdownPartMetadataSettingsSettingsArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .markdownSource(markdownSource?.applyValue({ args0 -> args0 }))
            .markdownUri(markdownUri?.applyValue({ args0 -> args0 }))
            .subtitle(subtitle?.applyValue({ args0 -> args0 }))
            .title(title?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MarkdownPartMetadataSettingsSettingsArgs].
 */
@PulumiTagMarker
public class MarkdownPartMetadataSettingsSettingsArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var markdownSource: Output<Int>? = null

    private var markdownUri: Output<String>? = null

    private var subtitle: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value The content of the markdown part.
     */
    @JvmName("muhpltpamjsuutnr")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value The source of the content of the markdown part.
     */
    @JvmName("kbpbqubppnewltin")
    public suspend fun markdownSource(`value`: Output<Int>) {
        this.markdownSource = value
    }

    /**
     * @param value The uri of markdown content.
     */
    @JvmName("ffaquyfxknoggnvq")
    public suspend fun markdownUri(`value`: Output<String>) {
        this.markdownUri = value
    }

    /**
     * @param value The subtitle of the markdown part.
     */
    @JvmName("iwkkhtcnujljwjss")
    public suspend fun subtitle(`value`: Output<String>) {
        this.subtitle = value
    }

    /**
     * @param value The title of the markdown part.
     */
    @JvmName("mehdrfdksewtguas")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value The content of the markdown part.
     */
    @JvmName("offjeyfcfllyupqt")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value The source of the content of the markdown part.
     */
    @JvmName("fyhjbnxbsfymskwq")
    public suspend fun markdownSource(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markdownSource = mapped
    }

    /**
     * @param value The uri of markdown content.
     */
    @JvmName("dwtotoxuoqrevdsg")
    public suspend fun markdownUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.markdownUri = mapped
    }

    /**
     * @param value The subtitle of the markdown part.
     */
    @JvmName("iikesfjwalmvvcti")
    public suspend fun subtitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subtitle = mapped
    }

    /**
     * @param value The title of the markdown part.
     */
    @JvmName("rouneydqtpwyscng")
    public suspend fun title(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): MarkdownPartMetadataSettingsSettingsArgs =
        MarkdownPartMetadataSettingsSettingsArgs(
            content = content,
            markdownSource = markdownSource,
            markdownUri = markdownUri,
            subtitle = subtitle,
            title = title,
        )
}
