@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.portal.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * List of list of items that violate tenant's configuration.
 * @property nextLink The URL to use for getting the next set of results.
 * @property value The array of violations.
 */
public data class ListListTenantConfigurationViolationResult(
    public val nextLink: String? = null,
    public val `value`: List<ViolationResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.portal.outputs.ListListTenantConfigurationViolationResult):
            ListListTenantConfigurationViolationResult = ListListTenantConfigurationViolationResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.portal.kotlin.outputs.ViolationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
