@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin

import com.pulumi.azurenative.powerbi.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.powerbi.kotlin.enums.ResourceProvisioningState
import com.pulumi.azurenative.powerbi.kotlin.inputs.ConnectionStateArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.ConnectionStateArgsBuilder
import com.pulumi.azurenative.powerbi.kotlin.inputs.PrivateEndpointArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.PrivateEndpointArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2020-06-01. Prior API version in Azure Native 1.x: 2020-06-01.
 * ## Example Usage
 * ### Updates status of private endpoint connection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.PowerBI.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         AzureResourceName = "azureResourceName",
 *         PrivateEndpoint = new AzureNative.PowerBI.Inputs.PrivateEndpointArgs
 *         {
 *             Id = "/subscriptions/a0020869-4d28-422a-89f4-c2413130d73c/resourceGroups/resourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpointName",
 *         },
 *         PrivateEndpointName = "myPrivateEndpointName",
 *         PrivateLinkServiceConnectionState = new AzureNative.PowerBI.Inputs.ConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "",
 *             Status = "Approved ",
 *         },
 *         ResourceGroupName = "resourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerbi/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerbi.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &powerbi.PrivateEndpointConnectionArgs{
 * 			AzureResourceName: pulumi.String("azureResourceName"),
 * 			PrivateEndpoint: &powerbi.PrivateEndpointArgs{
 * 				Id: pulumi.String("/subscriptions/a0020869-4d28-422a-89f4-c2413130d73c/resourceGroups/resourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpointName"),
 * 			},
 * 			PrivateEndpointName: pulumi.String("myPrivateEndpointName"),
 * 			PrivateLinkServiceConnectionState: &powerbi.ConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String(""),
 * 				Status:          pulumi.String("Approved "),
 * 			},
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerbi.PrivateEndpointConnection;
 * import com.pulumi.azurenative.powerbi.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.powerbi.inputs.PrivateEndpointArgs;
 * import com.pulumi.azurenative.powerbi.inputs.ConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .azureResourceName("azureResourceName")
 *             .privateEndpoint(PrivateEndpointArgs.builder()
 *                 .id("/subscriptions/a0020869-4d28-422a-89f4-c2413130d73c/resourceGroups/resourceGroup/providers/Microsoft.Network/privateEndpoints/myPrivateEndpointName")
 *                 .build())
 *             .privateEndpointName("myPrivateEndpointName")
 *             .privateLinkServiceConnectionState(ConnectionStateArgs.builder()
 *                 .actionsRequired("None")
 *                 .description("")
 *                 .status("Approved ")
 *                 .build())
 *             .resourceGroupName("resourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbi:PrivateEndpointConnection myPrivateEndpointName.58ffb8de-89ad-41eb-9f8f-de0a7db9d721 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/privateLinkServicesForPowerBI/{azureResourceName}/privateEndpointConnections/{privateEndpointName}
 * ```
 * @property azureResourceName The name of the Azure resource.
 * @property privateEndpoint Specifies the private endpoint.
 * @property privateEndpointName The name of the private endpoint.
 * @property privateLinkServiceConnectionState Specifies the connection state.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 * @property resourceGroupName The name of the resource group.
 */
public data class PrivateEndpointConnectionArgs(
    public val azureResourceName: Output<String>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateEndpointName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, ResourceProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.powerbi.PrivateEndpointConnectionArgs.builder()
            .azureResourceName(azureResourceName?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointName(privateEndpointName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var azureResourceName: Output<String>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateEndpointName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, ResourceProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Azure resource.
     */
    @JvmName("inifsipjdemyqtip")
    public suspend fun azureResourceName(`value`: Output<String>) {
        this.azureResourceName = value
    }

    /**
     * @param value Specifies the private endpoint.
     */
    @JvmName("nmtqrlijygjwuqsf")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("ccxdfitscqxsayco")
    public suspend fun privateEndpointName(`value`: Output<String>) {
        this.privateEndpointName = value
    }

    /**
     * @param value Specifies the connection state.
     */
    @JvmName("sjbcsatcdtaouikp")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("pmduwpgvoyuuhmnl")
    public suspend fun provisioningState(`value`: Output<Either<String, ResourceProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("mcfmeqcgjhuigrfa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Azure resource.
     */
    @JvmName("qoradqisiblbcknp")
    public suspend fun azureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureResourceName = mapped
    }

    /**
     * @param value Specifies the private endpoint.
     */
    @JvmName("fmbgclviltntvdmf")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument Specifies the private endpoint.
     */
    @JvmName("thujistrwuqyfwxc")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("sxlvthjeemrndetj")
    public suspend fun privateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointName = mapped
    }

    /**
     * @param value Specifies the connection state.
     */
    @JvmName("xaiquyvcjexnnopo")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Specifies the connection state.
     */
    @JvmName("ouceunyffecktkqp")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("aqcbuoctxyrsjxcn")
    public suspend fun provisioningState(`value`: Either<String, ResourceProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("yodvunddwvmkspna")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("wcgipuyrlqtcwnuy")
    public fun provisioningState(`value`: ResourceProvisioningState) {
        val toBeMapped = Either.ofRight<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iwitqfpvmuqddriw")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        azureResourceName = azureResourceName,
        privateEndpoint = privateEndpoint,
        privateEndpointName = privateEndpointName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
