@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin

import com.pulumi.azurenative.powerbi.WorkspaceCollectionArgs.builder
import com.pulumi.azurenative.powerbi.kotlin.inputs.AzureSkuArgs
import com.pulumi.azurenative.powerbi.kotlin.inputs.AzureSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2016-01-29. Prior API version in Azure Native 1.x: 2016-01-29.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbi:WorkspaceCollection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBI/workspaceCollections/{workspaceCollectionName}
 * ```
 * @property location Azure location
 * @property resourceGroupName Azure resource group
 * @property sku
 * @property tags
 * @property workspaceCollectionName Power BI Embedded Workspace Collection name
 */
public data class WorkspaceCollectionArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<AzureSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceCollectionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.WorkspaceCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbi.WorkspaceCollectionArgs =
        com.pulumi.azurenative.powerbi.WorkspaceCollectionArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceCollectionName(workspaceCollectionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceCollectionArgs].
 */
@PulumiTagMarker
public class WorkspaceCollectionArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<AzureSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceCollectionName: Output<String>? = null

    /**
     * @param value Azure location
     */
    @JvmName("msffqgwotacajnwy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource group
     */
    @JvmName("nilnydvocnjqpphw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("gvduwkqswkxxsget")
    public suspend fun sku(`value`: Output<AzureSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value
     */
    @JvmName("uxsfepsekrdfjipg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Power BI Embedded Workspace Collection name
     */
    @JvmName("hnauodfsdsgbamfu")
    public suspend fun workspaceCollectionName(`value`: Output<String>) {
        this.workspaceCollectionName = value
    }

    /**
     * @param value Azure location
     */
    @JvmName("jhrtcyhqbxpyggjj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource group
     */
    @JvmName("bovyijwecmloytxm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcprcankjxjmeivu")
    public suspend fun sku(`value`: AzureSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rasbsbcyengriolo")
    public suspend fun sku(argument: suspend AzureSkuArgsBuilder.() -> Unit) {
        val toBeMapped = AzureSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value
     */
    @JvmName("ssrxvfumwbmrrodb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("pqsmanpgydacrdlc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Power BI Embedded Workspace Collection name
     */
    @JvmName("llnjtwvmgdjasohu")
    public suspend fun workspaceCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceCollectionName = mapped
    }

    internal fun build(): WorkspaceCollectionArgs = WorkspaceCollectionArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        workspaceCollectionName = workspaceCollectionName,
    )
}
