@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbi.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Provisioning state of the Private Endpoint Connection.
 */
public enum class ResourceProvisioningState(
    public val javaValue: com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState> {
    Creating(com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState.Creating),
    Updating(com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState.Updating),
    Deleting(com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState.Deleting),
    Succeeded(com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState.Succeeded),
    Canceled(com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState.Canceled),
    Failed(com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState.Failed),
    ;

    override fun toJava(): com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.powerbi.enums.ResourceProvisioningState):
            ResourceProvisioningState =
            ResourceProvisioningState.values().first { it.javaValue == javaType }
    }
}
