@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin

import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.AutoScaleVCoreSkuResponse
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.AutoScaleVCoreSkuResponse.Companion.toKotlin as autoScaleVCoreSkuResponseToKotlin
import com.pulumi.azurenative.powerbidedicated.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AutoScaleVCore].
 */
@PulumiTagMarker
public class AutoScaleVCoreResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoScaleVCoreArgs = AutoScaleVCoreArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoScaleVCoreArgsBuilder.() -> Unit) {
        val builder = AutoScaleVCoreArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoScaleVCore {
        val builtJavaResource =
            com.pulumi.azurenative.powerbidedicated.AutoScaleVCore(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AutoScaleVCore(builtJavaResource)
    }
}

/**
 * Represents an instance of an auto scale v-core resource.
 * Azure REST API version: 2021-01-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * ## Example Usage
 * ### Create auto scale v-core
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var autoScaleVCore = new AzureNative.PowerBIDedicated.AutoScaleVCore("autoScaleVCore", new()
 *     {
 *         CapacityLimit = 10,
 *         CapacityObjectId = "a28f00bd-5330-4572-88f1-fa883e074785",
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         Sku = new AzureNative.PowerBIDedicated.Inputs.AutoScaleVCoreSkuArgs
 *         {
 *             Capacity = 0,
 *             Name = "AutoScale",
 *             Tier = AzureNative.PowerBIDedicated.VCoreSkuTier.AutoScale,
 *         },
 *         Tags =
 *         {
 *             { "testKey", "testValue" },
 *         },
 *         VcoreName = "testvcore",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerbidedicated/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerbidedicated.NewAutoScaleVCore(ctx, "autoScaleVCore", &powerbidedicated.AutoScaleVCoreArgs{
 * 			CapacityLimit:     pulumi.Int(10),
 * 			CapacityObjectId:  pulumi.String("a28f00bd-5330-4572-88f1-fa883e074785"),
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			Sku: &powerbidedicated.AutoScaleVCoreSkuArgs{
 * 				Capacity: pulumi.Int(0),
 * 				Name:     pulumi.String("AutoScale"),
 * 				Tier:     pulumi.String(powerbidedicated.VCoreSkuTierAutoScale),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"testKey": pulumi.String("testValue"),
 * 			},
 * 			VcoreName: pulumi.String("testvcore"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerbidedicated.AutoScaleVCore;
 * import com.pulumi.azurenative.powerbidedicated.AutoScaleVCoreArgs;
 * import com.pulumi.azurenative.powerbidedicated.inputs.AutoScaleVCoreSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var autoScaleVCore = new AutoScaleVCore("autoScaleVCore", AutoScaleVCoreArgs.builder()
 *             .capacityLimit(10)
 *             .capacityObjectId("a28f00bd-5330-4572-88f1-fa883e074785")
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .sku(AutoScaleVCoreSkuArgs.builder()
 *                 .capacity(0)
 *                 .name("AutoScale")
 *                 .tier("AutoScale")
 *                 .build())
 *             .tags(Map.of("testKey", "testValue"))
 *             .vcoreName("testvcore")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerbidedicated:AutoScaleVCore testvcore /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}
 * ```
 */
public class AutoScaleVCore internal constructor(
    override val javaResource: com.pulumi.azurenative.powerbidedicated.AutoScaleVCore,
) : KotlinCustomResource(javaResource, AutoScaleVCoreMapper) {
    /**
     * The maximum capacity of an auto scale v-core resource.
     */
    public val capacityLimit: Output<Int>?
        get() = javaResource.capacityLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The object ID of the capacity resource associated with the auto scale v-core resource.
     */
    public val capacityObjectId: Output<String>?
        get() = javaResource.capacityObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of the PowerBI Dedicated resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the PowerBI Dedicated resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment state of an auto scale v-core resource. The provisioningState is to indicate states for resource provisioning.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The SKU of the auto scale v-core resource.
     */
    public val sku: Output<AutoScaleVCoreSkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                autoScaleVCoreSkuResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>?
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    systemDataResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value pairs of additional resource provisioning properties.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the PowerBI Dedicated resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AutoScaleVCoreMapper : ResourceMapper<AutoScaleVCore> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.powerbidedicated.AutoScaleVCore::class == javaResource::class

    override fun map(javaResource: Resource): AutoScaleVCore = AutoScaleVCore(
        javaResource as
            com.pulumi.azurenative.powerbidedicated.AutoScaleVCore,
    )
}

/**
 * @see [AutoScaleVCore].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoScaleVCore].
 */
public suspend fun autoScaleVCore(
    name: String,
    block: suspend AutoScaleVCoreResourceBuilder.() -> Unit,
): AutoScaleVCore {
    val builder = AutoScaleVCoreResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoScaleVCore].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoScaleVCore(name: String): AutoScaleVCore {
    val builder = AutoScaleVCoreResourceBuilder()
    builder.name(name)
    return builder.build()
}
