@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.inputs

import com.pulumi.azurenative.powerbidedicated.inputs.CapacitySkuArgs.builder
import com.pulumi.azurenative.powerbidedicated.kotlin.enums.CapacitySkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the SKU name and Azure pricing tier for PowerBI Dedicated capacity resource.
 * @property capacity The capacity of the SKU.
 * @property name Name of the SKU level.
 * @property tier The name of the Azure pricing tier to which the SKU applies.
 */
public data class CapacitySkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>,
    public val tier: Output<Either<String, CapacitySkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.inputs.CapacitySkuArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.inputs.CapacitySkuArgs =
        com.pulumi.azurenative.powerbidedicated.inputs.CapacitySkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CapacitySkuArgs].
 */
@PulumiTagMarker
public class CapacitySkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<Either<String, CapacitySkuTier>>? = null

    /**
     * @param value The capacity of the SKU.
     */
    @JvmName("efnhncibjgvuduyu")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of the SKU level.
     */
    @JvmName("bwjnhftquvdmofxd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("rotmmjfftvpgjpyh")
    public suspend fun tier(`value`: Output<Either<String, CapacitySkuTier>>) {
        this.tier = value
    }

    /**
     * @param value The capacity of the SKU.
     */
    @JvmName("baidbgupdhjwrows")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of the SKU level.
     */
    @JvmName("glaeoyqryhihmtgr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("kdghtqcpavdskhld")
    public suspend fun tier(`value`: Either<String, CapacitySkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("toprmyogyxkjuncn")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CapacitySkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value The name of the Azure pricing tier to which the SKU applies.
     */
    @JvmName("ajyxagonaeufyplj")
    public fun tier(`value`: CapacitySkuTier) {
        val toBeMapped = Either.ofRight<String, CapacitySkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): CapacitySkuArgs = CapacitySkuArgs(
        capacity = capacity,
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
