@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.inputs

import com.pulumi.azurenative.powerbidedicated.inputs.GetAutoScaleVCorePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
 * @property vcoreName The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
 */
public data class GetAutoScaleVCorePlainArgs(
    public val resourceGroupName: String,
    public val vcoreName: String,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.inputs.GetAutoScaleVCorePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.inputs.GetAutoScaleVCorePlainArgs =
        com.pulumi.azurenative.powerbidedicated.inputs.GetAutoScaleVCorePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vcoreName(vcoreName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAutoScaleVCorePlainArgs].
 */
@PulumiTagMarker
public class GetAutoScaleVCorePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vcoreName: String? = null

    /**
     * @param value The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("iawccsflilsuoagu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the auto scale v-core. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("tlhjaudtlhcvhuxt")
    public suspend fun vcoreName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vcoreName = mapped
    }

    internal fun build(): GetAutoScaleVCorePlainArgs = GetAutoScaleVCorePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vcoreName = vcoreName ?: throw PulumiNullFieldException("vcoreName"),
    )
}
