@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerbidedicated.kotlin.inputs

import com.pulumi.azurenative.powerbidedicated.inputs.GetCapacityDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dedicatedCapacityName The name of the dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
 * @property resourceGroupName The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
 */
public data class GetCapacityDetailsPlainArgs(
    public val dedicatedCapacityName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.powerbidedicated.inputs.GetCapacityDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.powerbidedicated.inputs.GetCapacityDetailsPlainArgs =
        com.pulumi.azurenative.powerbidedicated.inputs.GetCapacityDetailsPlainArgs.builder()
            .dedicatedCapacityName(dedicatedCapacityName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCapacityDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetCapacityDetailsPlainArgsBuilder internal constructor() {
    private var dedicatedCapacityName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the dedicated capacity. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("swffbpneniojovwy")
    public suspend fun dedicatedCapacityName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dedicatedCapacityName = mapped
    }

    /**
     * @param value The name of the Azure Resource group of which a given PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no more than 90.
     */
    @JvmName("ygwrenayyriyijxj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCapacityDetailsPlainArgs = GetCapacityDetailsPlainArgs(
        dedicatedCapacityName = dedicatedCapacityName ?: throw
            PulumiNullFieldException("dedicatedCapacityName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
