@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin

import com.pulumi.azurenative.powerplatform.kotlin.outputs.EnterprisePolicyIdentityResponse
import com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseEncryption
import com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseLockbox
import com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseNetworkInjection
import com.pulumi.azurenative.powerplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.powerplatform.kotlin.outputs.EnterprisePolicyIdentityResponse.Companion.toKotlin as enterprisePolicyIdentityResponseToKotlin
import com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseEncryption.Companion.toKotlin as propertiesResponseEncryptionToKotlin
import com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseLockbox.Companion.toKotlin as propertiesResponseLockboxToKotlin
import com.pulumi.azurenative.powerplatform.kotlin.outputs.PropertiesResponseNetworkInjection.Companion.toKotlin as propertiesResponseNetworkInjectionToKotlin
import com.pulumi.azurenative.powerplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [EnterprisePolicy].
 */
@PulumiTagMarker
public class EnterprisePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnterprisePolicyArgs = EnterprisePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnterprisePolicyArgsBuilder.() -> Unit) {
        val builder = EnterprisePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EnterprisePolicy {
        val builtJavaResource =
            com.pulumi.azurenative.powerplatform.EnterprisePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return EnterprisePolicy(builtJavaResource)
    }
}

/**
 * Definition of the EnterprisePolicy.
 * Azure REST API version: 2020-10-30-preview. Prior API version in Azure Native 1.x: 2020-10-30-preview.
 * ## Example Usage
 * ### Create or update EnterprisePolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enterprisePolicy = new AzureNative.PowerPlatform.EnterprisePolicy("enterprisePolicy", new()
 *     {
 *         EnterprisePolicyName = "enterprisePolicy",
 *         Identity = new AzureNative.PowerPlatform.Inputs.EnterprisePolicyIdentityArgs
 *         {
 *             Type = AzureNative.PowerPlatform.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.PowerPlatform.EnterprisePolicyKind.Lockbox,
 *         Location = "East US",
 *         ResourceGroupName = "resourceGroup",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerplatform.NewEnterprisePolicy(ctx, "enterprisePolicy", &powerplatform.EnterprisePolicyArgs{
 * 			EnterprisePolicyName: pulumi.String("enterprisePolicy"),
 * 			Identity: &powerplatform.EnterprisePolicyIdentityArgs{
 * 				Type: powerplatform.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:              pulumi.String(powerplatform.EnterprisePolicyKindLockbox),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerplatform.EnterprisePolicy;
 * import com.pulumi.azurenative.powerplatform.EnterprisePolicyArgs;
 * import com.pulumi.azurenative.powerplatform.inputs.EnterprisePolicyIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enterprisePolicy = new EnterprisePolicy("enterprisePolicy", EnterprisePolicyArgs.builder()
 *             .enterprisePolicyName("enterprisePolicy")
 *             .identity(EnterprisePolicyIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("Lockbox")
 *             .location("East US")
 *             .resourceGroupName("resourceGroup")
 *             .tags(Map.of("Organization", "Administration"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerplatform:EnterprisePolicy enterprisePolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerPlatform/enterprisePolicies/{enterprisePolicyName}
 * ```
 */
public class EnterprisePolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.powerplatform.EnterprisePolicy,
) : KotlinCustomResource(javaResource, EnterprisePolicyMapper) {
    /**
     * The encryption settings for a configuration store.
     */
    public val encryption: Output<PropertiesResponseEncryption>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    propertiesResponseEncryptionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The health status of the resource.
     */
    public val healthStatus: Output<String>?
        get() = javaResource.healthStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity of the EnterprisePolicy.
     */
    public val identity: Output<EnterprisePolicyIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    enterprisePolicyIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The kind (type) of Enterprise Policy.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Settings concerning lockbox.
     */
    public val lockbox: Output<PropertiesResponseLockbox>?
        get() = javaResource.lockbox().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    propertiesResponseLockboxToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Settings concerning network injection.
     */
    public val networkInjection: Output<PropertiesResponseNetworkInjection>?
        get() = javaResource.networkInjection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> propertiesResponseNetworkInjectionToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The internally assigned unique identifier of the resource.
     */
    public val systemId: Output<String>
        get() = javaResource.systemId().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object EnterprisePolicyMapper : ResourceMapper<EnterprisePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.powerplatform.EnterprisePolicy::class == javaResource::class

    override fun map(javaResource: Resource): EnterprisePolicy = EnterprisePolicy(
        javaResource as
            com.pulumi.azurenative.powerplatform.EnterprisePolicy,
    )
}

/**
 * @see [EnterprisePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EnterprisePolicy].
 */
public suspend fun enterprisePolicy(
    name: String,
    block: suspend EnterprisePolicyResourceBuilder.() -> Unit,
): EnterprisePolicy {
    val builder = EnterprisePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EnterprisePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun enterprisePolicy(name: String): EnterprisePolicy {
    val builder = EnterprisePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
