@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin

import com.pulumi.azurenative.powerplatform.EnterprisePolicyArgs.builder
import com.pulumi.azurenative.powerplatform.kotlin.enums.EnterprisePolicyKind
import com.pulumi.azurenative.powerplatform.kotlin.enums.HealthStatus
import com.pulumi.azurenative.powerplatform.kotlin.inputs.EnterprisePolicyIdentityArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.EnterprisePolicyIdentityArgsBuilder
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PropertiesEncryptionArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PropertiesEncryptionArgsBuilder
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PropertiesLockboxArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PropertiesLockboxArgsBuilder
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PropertiesNetworkInjectionArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PropertiesNetworkInjectionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Definition of the EnterprisePolicy.
 * Azure REST API version: 2020-10-30-preview. Prior API version in Azure Native 1.x: 2020-10-30-preview.
 * ## Example Usage
 * ### Create or update EnterprisePolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var enterprisePolicy = new AzureNative.PowerPlatform.EnterprisePolicy("enterprisePolicy", new()
 *     {
 *         EnterprisePolicyName = "enterprisePolicy",
 *         Identity = new AzureNative.PowerPlatform.Inputs.EnterprisePolicyIdentityArgs
 *         {
 *             Type = AzureNative.PowerPlatform.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = AzureNative.PowerPlatform.EnterprisePolicyKind.Lockbox,
 *         Location = "East US",
 *         ResourceGroupName = "resourceGroup",
 *         Tags =
 *         {
 *             { "Organization", "Administration" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerplatform.NewEnterprisePolicy(ctx, "enterprisePolicy", &powerplatform.EnterprisePolicyArgs{
 * 			EnterprisePolicyName: pulumi.String("enterprisePolicy"),
 * 			Identity: &powerplatform.EnterprisePolicyIdentityArgs{
 * 				Type: powerplatform.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:              pulumi.String(powerplatform.EnterprisePolicyKindLockbox),
 * 			Location:          pulumi.String("East US"),
 * 			ResourceGroupName: pulumi.String("resourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Organization": pulumi.String("Administration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerplatform.EnterprisePolicy;
 * import com.pulumi.azurenative.powerplatform.EnterprisePolicyArgs;
 * import com.pulumi.azurenative.powerplatform.inputs.EnterprisePolicyIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var enterprisePolicy = new EnterprisePolicy("enterprisePolicy", EnterprisePolicyArgs.builder()
 *             .enterprisePolicyName("enterprisePolicy")
 *             .identity(EnterprisePolicyIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .kind("Lockbox")
 *             .location("East US")
 *             .resourceGroupName("resourceGroup")
 *             .tags(Map.of("Organization", "Administration"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerplatform:EnterprisePolicy enterprisePolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerPlatform/enterprisePolicies/{enterprisePolicyName}
 * ```
 * @property encryption The encryption settings for a configuration store.
 * @property enterprisePolicyName Name of the EnterprisePolicy.
 * @property healthStatus The health status of the resource.
 * @property identity The identity of the EnterprisePolicy.
 * @property kind The kind (type) of Enterprise Policy.
 * @property location The geo-location where the resource lives
 * @property lockbox Settings concerning lockbox.
 * @property networkInjection Settings concerning network injection.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class EnterprisePolicyArgs(
    public val encryption: Output<PropertiesEncryptionArgs>? = null,
    public val enterprisePolicyName: Output<String>? = null,
    public val healthStatus: Output<Either<String, HealthStatus>>? = null,
    public val identity: Output<EnterprisePolicyIdentityArgs>? = null,
    public val kind: Output<Either<String, EnterprisePolicyKind>>? = null,
    public val location: Output<String>? = null,
    public val lockbox: Output<PropertiesLockboxArgs>? = null,
    public val networkInjection: Output<PropertiesNetworkInjectionArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.EnterprisePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.EnterprisePolicyArgs =
        com.pulumi.azurenative.powerplatform.EnterprisePolicyArgs.builder()
            .encryption(encryption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enterprisePolicyName(enterprisePolicyName?.applyValue({ args0 -> args0 }))
            .healthStatus(
                healthStatus?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(
                kind?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .lockbox(lockbox?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkInjection(networkInjection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnterprisePolicyArgs].
 */
@PulumiTagMarker
public class EnterprisePolicyArgsBuilder internal constructor() {
    private var encryption: Output<PropertiesEncryptionArgs>? = null

    private var enterprisePolicyName: Output<String>? = null

    private var healthStatus: Output<Either<String, HealthStatus>>? = null

    private var identity: Output<EnterprisePolicyIdentityArgs>? = null

    private var kind: Output<Either<String, EnterprisePolicyKind>>? = null

    private var location: Output<String>? = null

    private var lockbox: Output<PropertiesLockboxArgs>? = null

    private var networkInjection: Output<PropertiesNetworkInjectionArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The encryption settings for a configuration store.
     */
    @JvmName("fsjvtdbkjuiifadc")
    public suspend fun encryption(`value`: Output<PropertiesEncryptionArgs>) {
        this.encryption = value
    }

    /**
     * @param value Name of the EnterprisePolicy.
     */
    @JvmName("tjsbdxfxrorvkixu")
    public suspend fun enterprisePolicyName(`value`: Output<String>) {
        this.enterprisePolicyName = value
    }

    /**
     * @param value The health status of the resource.
     */
    @JvmName("wmdsyhpdbltkwwqt")
    public suspend fun healthStatus(`value`: Output<Either<String, HealthStatus>>) {
        this.healthStatus = value
    }

    /**
     * @param value The identity of the EnterprisePolicy.
     */
    @JvmName("qkbcpjotybvqygdy")
    public suspend fun identity(`value`: Output<EnterprisePolicyIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The kind (type) of Enterprise Policy.
     */
    @JvmName("nkaajwulpjyksnns")
    public suspend fun kind(`value`: Output<Either<String, EnterprisePolicyKind>>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kenmoxxebigrktbd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Settings concerning lockbox.
     */
    @JvmName("vtclsyutwfygpmmi")
    public suspend fun lockbox(`value`: Output<PropertiesLockboxArgs>) {
        this.lockbox = value
    }

    /**
     * @param value Settings concerning network injection.
     */
    @JvmName("xpnjwonrhvwccbeq")
    public suspend fun networkInjection(`value`: Output<PropertiesNetworkInjectionArgs>) {
        this.networkInjection = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rawokydvnxlpukvr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vaqosrhpamsrryer")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The encryption settings for a configuration store.
     */
    @JvmName("tcrgtxsixigiflxv")
    public suspend fun encryption(`value`: PropertiesEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param argument The encryption settings for a configuration store.
     */
    @JvmName("syiycicjtbehstwk")
    public suspend fun encryption(argument: suspend PropertiesEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = PropertiesEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryption = mapped
    }

    /**
     * @param value Name of the EnterprisePolicy.
     */
    @JvmName("fubomltwufefdjph")
    public suspend fun enterprisePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterprisePolicyName = mapped
    }

    /**
     * @param value The health status of the resource.
     */
    @JvmName("emryodlgwvxibmpm")
    public suspend fun healthStatus(`value`: Either<String, HealthStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value The health status of the resource.
     */
    @JvmName("fpbmlyvyuiyiubht")
    public fun healthStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HealthStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value The health status of the resource.
     */
    @JvmName("eduqnyubtibguqar")
    public fun healthStatus(`value`: HealthStatus) {
        val toBeMapped = Either.ofRight<String, HealthStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthStatus = mapped
    }

    /**
     * @param value The identity of the EnterprisePolicy.
     */
    @JvmName("oolqvwixsvnujtiq")
    public suspend fun identity(`value`: EnterprisePolicyIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The identity of the EnterprisePolicy.
     */
    @JvmName("elipaehqdjdthqle")
    public suspend fun identity(argument: suspend EnterprisePolicyIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EnterprisePolicyIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The kind (type) of Enterprise Policy.
     */
    @JvmName("vxffdmwwujlhdhvd")
    public suspend fun kind(`value`: Either<String, EnterprisePolicyKind>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind (type) of Enterprise Policy.
     */
    @JvmName("onyejaaamnfdrlrg")
    public fun kind(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnterprisePolicyKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The kind (type) of Enterprise Policy.
     */
    @JvmName("oldsvggvwaolmyvm")
    public fun kind(`value`: EnterprisePolicyKind) {
        val toBeMapped = Either.ofRight<String, EnterprisePolicyKind>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pnourajaonvitgjl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Settings concerning lockbox.
     */
    @JvmName("ydvgtbrlklasyalr")
    public suspend fun lockbox(`value`: PropertiesLockboxArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockbox = mapped
    }

    /**
     * @param argument Settings concerning lockbox.
     */
    @JvmName("dedsgsnhyaadvdks")
    public suspend fun lockbox(argument: suspend PropertiesLockboxArgsBuilder.() -> Unit) {
        val toBeMapped = PropertiesLockboxArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lockbox = mapped
    }

    /**
     * @param value Settings concerning network injection.
     */
    @JvmName("rbcfqjbphqmxsfld")
    public suspend fun networkInjection(`value`: PropertiesNetworkInjectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInjection = mapped
    }

    /**
     * @param argument Settings concerning network injection.
     */
    @JvmName("uitnphbdjhwgotni")
    public suspend
    fun networkInjection(argument: suspend PropertiesNetworkInjectionArgsBuilder.() -> Unit) {
        val toBeMapped = PropertiesNetworkInjectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkInjection = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("psoviepmwcaiekwp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("univyosylxfotnpr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("korxsucjrxbysvxm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnterprisePolicyArgs = EnterprisePolicyArgs(
        encryption = encryption,
        enterprisePolicyName = enterprisePolicyName,
        healthStatus = healthStatus,
        identity = identity,
        kind = kind,
        location = location,
        lockbox = lockbox,
        networkInjection = networkInjection,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
