@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin

import com.pulumi.azurenative.powerplatform.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.powerplatform.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A private endpoint connection
 * Azure REST API version: 2020-10-30-preview. Prior API version in Azure Native 1.x: 2020-10-30-preview.
 * ## Example Usage
 * ### Approve or reject a private endpoint connection with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.PowerPlatform.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         EnterprisePolicyName = "ddb1",
 *         PrivateEndpointConnectionName = "privateEndpointConnectionName",
 *         PrivateLinkServiceConnectionState = new AzureNative.PowerPlatform.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Approved by johndoe@contoso.com",
 *             Status = AzureNative.PowerPlatform.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/powerplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := powerplatform.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &powerplatform.PrivateEndpointConnectionArgs{
 * 			EnterprisePolicyName:          pulumi.String("ddb1"),
 * 			PrivateEndpointConnectionName: pulumi.String("privateEndpointConnectionName"),
 * 			PrivateLinkServiceConnectionState: &powerplatform.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Approved by johndoe@contoso.com"),
 * 				Status:      pulumi.String(powerplatform.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.powerplatform.PrivateEndpointConnection;
 * import com.pulumi.azurenative.powerplatform.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.powerplatform.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .enterprisePolicyName("ddb1")
 *             .privateEndpointConnectionName("privateEndpointConnectionName")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Approved by johndoe@contoso.com")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:powerplatform:PrivateEndpointConnection privateEndpointConnectionName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerPlatform/enterprisePolicies/{enterprisePolicyName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property enterprisePolicyName EnterprisePolicy for the Microsoft Azure subscription.
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val enterprisePolicyName: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.powerplatform.PrivateEndpointConnectionArgs.builder()
            .enterprisePolicyName(enterprisePolicyName?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var enterprisePolicyName: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value EnterprisePolicy for the Microsoft Azure subscription.
     */
    @JvmName("tyjgbibsudelklgf")
    public suspend fun enterprisePolicyName(`value`: Output<String>) {
        this.enterprisePolicyName = value
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("rjhdwrlwfkcuvaen")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("rbanypyniuunvtdl")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pdiilycfijmegole")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value EnterprisePolicy for the Microsoft Azure subscription.
     */
    @JvmName("gdsemsnuhiqnwcoc")
    public suspend fun enterprisePolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enterprisePolicyName = mapped
    }

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("npfcxaimepyautsl")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("cvigityxyhwubkvy")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("lyarhyfemyjhhqwm")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bbfoecotdijtxdjc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        enterprisePolicyName = enterprisePolicyName,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
    )
}
