@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.KeyPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Url and version of the KeyVault Secret
 * @property name The identifier of the key vault key used to encrypt data.
 * @property version The version of the identity which will be used to access key vault.
 */
public data class KeyPropertiesArgs(
    public val name: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.KeyPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.KeyPropertiesArgs =
        com.pulumi.azurenative.powerplatform.inputs.KeyPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyPropertiesArgs].
 */
@PulumiTagMarker
public class KeyPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The identifier of the key vault key used to encrypt data.
     */
    @JvmName("sjubwrndwybcgfgg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The version of the identity which will be used to access key vault.
     */
    @JvmName("nhrxlvmomrxiumsc")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The identifier of the key vault key used to encrypt data.
     */
    @JvmName("mcggpfkcdlfgtufr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The version of the identity which will be used to access key vault.
     */
    @JvmName("ofbcvwakojamnnxk")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): KeyPropertiesArgs = KeyPropertiesArgs(
        name = name,
        version = version,
    )
}
