@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.PropertiesLockboxArgs.builder
import com.pulumi.azurenative.powerplatform.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings concerning lockbox.
 * @property state lockbox configuration
 */
public data class PropertiesLockboxArgs(
    public val state: Output<Either<String, State>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.PropertiesLockboxArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.PropertiesLockboxArgs =
        com.pulumi.azurenative.powerplatform.inputs.PropertiesLockboxArgs.builder()
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PropertiesLockboxArgs].
 */
@PulumiTagMarker
public class PropertiesLockboxArgsBuilder internal constructor() {
    private var state: Output<Either<String, State>>? = null

    /**
     * @param value lockbox configuration
     */
    @JvmName("ubmakuyrdiqpskrg")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value lockbox configuration
     */
    @JvmName("fignwlwcjqohenfh")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value lockbox configuration
     */
    @JvmName("pvaygogpxjilhsvh")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value lockbox configuration
     */
    @JvmName("xakgonohxheilutc")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): PropertiesLockboxArgs = PropertiesLockboxArgs(
        state = state,
    )
}
