@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.inputs

import com.pulumi.azurenative.powerplatform.inputs.SubnetPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of a subnet.
 * @property name Subnet name.
 */
public data class SubnetPropertiesArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.powerplatform.inputs.SubnetPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.powerplatform.inputs.SubnetPropertiesArgs =
        com.pulumi.azurenative.powerplatform.inputs.SubnetPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubnetPropertiesArgs].
 */
@PulumiTagMarker
public class SubnetPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Subnet name.
     */
    @JvmName("ccjonepyswpllfse")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Subnet name.
     */
    @JvmName("efyebtjxqfftisnp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SubnetPropertiesArgs = SubnetPropertiesArgs(
        name = name,
    )
}
