@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.powerplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Url and version of the KeyVault Secret
 * @property name The identifier of the key vault key used to encrypt data.
 * @property version The version of the identity which will be used to access key vault.
 */
public data class KeyPropertiesResponse(
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.powerplatform.outputs.KeyPropertiesResponse):
            KeyPropertiesResponse = KeyPropertiesResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
