@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin

import com.pulumi.azurenative.professionalservice.ProfessionalserviceFunctions.getProfessionalServiceSubscriptionLevelPlain
import com.pulumi.azurenative.professionalservice.kotlin.inputs.GetProfessionalServiceSubscriptionLevelPlainArgs
import com.pulumi.azurenative.professionalservice.kotlin.inputs.GetProfessionalServiceSubscriptionLevelPlainArgsBuilder
import com.pulumi.azurenative.professionalservice.kotlin.outputs.GetProfessionalServiceSubscriptionLevelResult
import com.pulumi.azurenative.professionalservice.kotlin.outputs.GetProfessionalServiceSubscriptionLevelResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ProfessionalserviceFunctions {
    /**
     * Gets information about the specified Subscription Level ProfessionalService.
     * Azure REST API version: 2023-07-01-preview.
     * @param argument null
     * @return ProfessionalService REST API resource definition.
     */
    public suspend
    fun getProfessionalServiceSubscriptionLevel(argument: GetProfessionalServiceSubscriptionLevelPlainArgs):
        GetProfessionalServiceSubscriptionLevelResult =
        toKotlin(getProfessionalServiceSubscriptionLevelPlain(argument.toJava()).await())

    /**
     * @see [getProfessionalServiceSubscriptionLevel].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the resource.
     * @param subscriptionId The Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
     * @return ProfessionalService REST API resource definition.
     */
    public suspend fun getProfessionalServiceSubscriptionLevel(
        resourceGroupName: String,
        resourceName: String,
        subscriptionId: String? = null,
    ): GetProfessionalServiceSubscriptionLevelResult {
        val argument = GetProfessionalServiceSubscriptionLevelPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            subscriptionId = subscriptionId,
        )
        return toKotlin(getProfessionalServiceSubscriptionLevelPlain(argument.toJava()).await())
    }

    /**
     * @see [getProfessionalServiceSubscriptionLevel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;professionalservice&#46;kotlin&#46;inputs&#46;GetProfessionalServiceSubscriptionLevelPlainArgs].
     * @return ProfessionalService REST API resource definition.
     */
    public suspend
    fun getProfessionalServiceSubscriptionLevel(argument: suspend GetProfessionalServiceSubscriptionLevelPlainArgsBuilder.() -> Unit):
        GetProfessionalServiceSubscriptionLevelResult {
        val builder = GetProfessionalServiceSubscriptionLevelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getProfessionalServiceSubscriptionLevelPlain(builtArgument.toJava()).await())
    }
}
