@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.professionalservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * ProfessionalService REST API resource definition.
 * @property id The resource uri
 * @property name The name of the resource
 * @property properties professionalService properties
 * @property tags the resource tags.
 * @property type Resource type.
 */
public data class GetProfessionalServiceSubscriptionLevelResult(
    public val id: String,
    public val name: String,
    public val properties: ProfessionalServiceResourceResponseProperties,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.professionalservice.outputs.GetProfessionalServiceSubscriptionLevelResult):
            GetProfessionalServiceSubscriptionLevelResult =
            GetProfessionalServiceSubscriptionLevelResult(
                id = javaType.id(),
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.professionalservice.kotlin.outputs.ProfessionalServiceResourceResponseProperties.Companion.toKotlin(args0)
                }),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
