@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.OperationByProviderRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * Other available API versions: 2021-05-01-preview.
 * ## Example Usage
 * ### Operations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var operationByProviderRegistration = new AzureNative.ProviderHub.OperationByProviderRegistration("operationByProviderRegistration", new()
 *     {
 *         ProviderNamespace = "Microsoft.Contoso",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewOperationByProviderRegistration(ctx, "operationByProviderRegistration", &providerhub.OperationByProviderRegistrationArgs{
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.OperationByProviderRegistration;
 * import com.pulumi.azurenative.providerhub.OperationByProviderRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var operationByProviderRegistration = new OperationByProviderRegistration("operationByProviderRegistration", OperationByProviderRegistrationArgs.builder()
 *             .providerNamespace("Microsoft.Contoso")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:OperationByProviderRegistration myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/operations/default
 * ```
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 */
public data class OperationByProviderRegistrationArgs(
    public val providerNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.OperationByProviderRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.OperationByProviderRegistrationArgs =
        com.pulumi.azurenative.providerhub.OperationByProviderRegistrationArgs.builder()
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OperationByProviderRegistrationArgs].
 */
@PulumiTagMarker
public class OperationByProviderRegistrationArgsBuilder internal constructor() {
    private var providerNamespace: Output<String>? = null

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("qgeuaebqdahwsgek")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("fqxankbgdvremura")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    internal fun build(): OperationByProviderRegistrationArgs = OperationByProviderRegistrationArgs(
        providerNamespace = providerNamespace,
    )
}
