@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.ResourceTypeRegistrationArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.ResourceTypeRegistrationPropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.ResourceTypeRegistrationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### ResourceTypeRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceTypeRegistration = new AzureNative.ProviderHub.ResourceTypeRegistration("resourceTypeRegistration", new()
 *     {
 *         Properties = new AzureNative.ProviderHub.Inputs.ResourceTypeRegistrationPropertiesArgs
 *         {
 *             Endpoints = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.ResourceTypeEndpointArgs
 *                 {
 *                     ApiVersions = new[]
 *                     {
 *                         "2020-06-01-preview",
 *                     },
 *                     Locations = new[]
 *                     {
 *                         "West US",
 *                         "East US",
 *                         "North Europe",
 *                     },
 *                     RequiredFeatures = new[]
 *                     {
 *                         "<feature flag>",
 *                     },
 *                 },
 *             },
 *             Management = new AzureNative.ProviderHub.Inputs.ResourceTypeRegistrationPropertiesManagementArgs
 *             {
 *                 IncidentContactEmail = "helpme@contoso.com",
 *                 IncidentRoutingService = "",
 *                 IncidentRoutingTeam = "",
 *                 ManifestOwners = new[]
 *                 {
 *                     "SPARTA-PlatformServiceAdministrator",
 *                 },
 *                 ResourceAccessPolicy = "NotSpecified",
 *                 ServiceTreeInfos = new[]
 *                 {
 *                     new AzureNative.ProviderHub.Inputs.ServiceTreeInfoArgs
 *                     {
 *                         ComponentId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                         Readiness = AzureNative.ProviderHub.Readiness.InDevelopment,
 *                         ServiceId = "d1b7d8ba-05e2-48e6-90d6-d781b99c6e69",
 *                     },
 *                 },
 *             },
 *             OpenApiConfiguration = new AzureNative.ProviderHub.Inputs.OpenApiConfigurationArgs
 *             {
 *                 Validation = new AzureNative.ProviderHub.Inputs.OpenApiValidationArgs
 *                 {
 *                     AllowNoncompliantCollectionResponse = true,
 *                 },
 *             },
 *             Regionality = AzureNative.ProviderHub.Regionality.Regional,
 *             ResourceConcurrencyControlOptions =
 *             {
 *                 { "patch", new AzureNative.ProviderHub.Inputs.ResourceConcurrencyControlOptionArgs
 *                 {
 *                     Policy = AzureNative.ProviderHub.Policy.SynchronizeBeginExtension,
 *                 } },
 *                 { "post", new AzureNative.ProviderHub.Inputs.ResourceConcurrencyControlOptionArgs
 *                 {
 *                     Policy = AzureNative.ProviderHub.Policy.SynchronizeBeginExtension,
 *                 } },
 *                 { "put", new AzureNative.ProviderHub.Inputs.ResourceConcurrencyControlOptionArgs
 *                 {
 *                     Policy = AzureNative.ProviderHub.Policy.SynchronizeBeginExtension,
 *                 } },
 *             },
 *             ResourceGraphConfiguration = new AzureNative.ProviderHub.Inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs
 *             {
 *                 ApiVersion = "2019-01-01",
 *                 Enabled = true,
 *             },
 *             RoutingType = AzureNative.ProviderHub.RoutingType.Default,
 *             SwaggerSpecifications = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.SwaggerSpecificationArgs
 *                 {
 *                     ApiVersions = new[]
 *                     {
 *                         "2020-06-01-preview",
 *                     },
 *                     SwaggerSpecFolderUri = "https://github.com/Azure/azure-rest-api-specs/blob/feature/azure/contoso/specification/contoso/resource-manager/Microsoft.SampleRP/",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         ResourceType = "employees",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewResourceTypeRegistration(ctx, "resourceTypeRegistration", &providerhub.ResourceTypeRegistrationArgs{
 * 			Properties: &providerhub.ResourceTypeRegistrationPropertiesArgs{
 * 				Endpoints: providerhub.ResourceTypeEndpointArray{
 * 					&providerhub.ResourceTypeEndpointArgs{
 * 						ApiVersions: pulumi.StringArray{
 * 							pulumi.String("2020-06-01-preview"),
 * 						},
 * 						Locations: pulumi.StringArray{
 * 							pulumi.String("West US"),
 * 							pulumi.String("East US"),
 * 							pulumi.String("North Europe"),
 * 						},
 * 						RequiredFeatures: pulumi.StringArray{
 * 							pulumi.String("<feature flag>"),
 * 						},
 * 					},
 * 				},
 * 				Management: &providerhub.ResourceTypeRegistrationPropertiesManagementArgs{
 * 					IncidentContactEmail:   pulumi.String("helpme@contoso.com"),
 * 					IncidentRoutingService: pulumi.String(""),
 * 					IncidentRoutingTeam:    pulumi.String(""),
 * 					ManifestOwners: pulumi.StringArray{
 * 						pulumi.String("SPARTA-PlatformServiceAdministrator"),
 * 					},
 * 					ResourceAccessPolicy: pulumi.String("NotSpecified"),
 * 					ServiceTreeInfos: providerhub.ServiceTreeInfoArray{
 * 						&providerhub.ServiceTreeInfoArgs{
 * 							ComponentId: pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * 							Readiness:   pulumi.String(providerhub.ReadinessInDevelopment),
 * 							ServiceId:   pulumi.String("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69"),
 * 						},
 * 					},
 * 				},
 * 				OpenApiConfiguration: &providerhub.OpenApiConfigurationArgs{
 * 					Validation: &providerhub.OpenApiValidationArgs{
 * 						AllowNoncompliantCollectionResponse: pulumi.Bool(true),
 * 					},
 * 				},
 * 				Regionality: pulumi.String(providerhub.RegionalityRegional),
 * 				ResourceConcurrencyControlOptions: providerhub.ResourceConcurrencyControlOptionMap{
 * 					"patch": &providerhub.ResourceConcurrencyControlOptionArgs{
 * 						Policy: pulumi.String(providerhub.PolicySynchronizeBeginExtension),
 * 					},
 * 					"post": &providerhub.ResourceConcurrencyControlOptionArgs{
 * 						Policy: pulumi.String(providerhub.PolicySynchronizeBeginExtension),
 * 					},
 * 					"put": &providerhub.ResourceConcurrencyControlOptionArgs{
 * 						Policy: pulumi.String(providerhub.PolicySynchronizeBeginExtension),
 * 					},
 * 				},
 * 				ResourceGraphConfiguration: &providerhub.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs{
 * 					ApiVersion: pulumi.String("2019-01-01"),
 * 					Enabled:    pulumi.Bool(true),
 * 				},
 * 				RoutingType: pulumi.String(providerhub.RoutingTypeDefault),
 * 				SwaggerSpecifications: providerhub.SwaggerSpecificationArray{
 * 					&providerhub.SwaggerSpecificationArgs{
 * 						ApiVersions: pulumi.StringArray{
 * 							pulumi.String("2020-06-01-preview"),
 * 						},
 * 						SwaggerSpecFolderUri: pulumi.String("https://github.com/Azure/azure-rest-api-specs/blob/feature/azure/contoso/specification/contoso/resource-manager/Microsoft.SampleRP/"),
 * 					},
 * 				},
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 			ResourceType:      pulumi.String("employees"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.ResourceTypeRegistration;
 * import com.pulumi.azurenative.providerhub.ResourceTypeRegistrationArgs;
 * import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesArgs;
 * import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesManagementArgs;
 * import com.pulumi.azurenative.providerhub.inputs.OpenApiConfigurationArgs;
 * import com.pulumi.azurenative.providerhub.inputs.OpenApiValidationArgs;
 * import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceTypeRegistration = new ResourceTypeRegistration("resourceTypeRegistration", ResourceTypeRegistrationArgs.builder()
 *             .properties(ResourceTypeRegistrationPropertiesArgs.builder()
 *                 .endpoints(ResourceTypeEndpointArgs.builder()
 *                     .apiVersions("2020-06-01-preview")
 *                     .locations(
 *                         "West US",
 *                         "East US",
 *                         "North Europe")
 *                     .requiredFeatures("<feature flag>")
 *                     .build())
 *                 .management(ResourceTypeRegistrationPropertiesManagementArgs.builder()
 *                     .incidentContactEmail("helpme@contoso.com")
 *                     .incidentRoutingService("")
 *                     .incidentRoutingTeam("")
 *                     .manifestOwners("SPARTA-PlatformServiceAdministrator")
 *                     .resourceAccessPolicy("NotSpecified")
 *                     .serviceTreeInfos(ServiceTreeInfoArgs.builder()
 *                         .componentId("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69")
 *                         .readiness("InDevelopment")
 *                         .serviceId("d1b7d8ba-05e2-48e6-90d6-d781b99c6e69")
 *                         .build())
 *                     .build())
 *                 .openApiConfiguration(OpenApiConfigurationArgs.builder()
 *                     .validation(OpenApiValidationArgs.builder()
 *                         .allowNoncompliantCollectionResponse(true)
 *                         .build())
 *                     .build())
 *                 .regionality("Regional")
 *                 .resourceConcurrencyControlOptions(Map.ofEntries(
 *                     Map.entry("patch", Map.of("policy", "SynchronizeBeginExtension")),
 *                     Map.entry("post", Map.of("policy", "SynchronizeBeginExtension")),
 *                     Map.entry("put", Map.of("policy", "SynchronizeBeginExtension"))
 *                 ))
 *                 .resourceGraphConfiguration(ResourceTypeRegistrationPropertiesResourceGraphConfigurationArgs.builder()
 *                     .apiVersion("2019-01-01")
 *                     .enabled(true)
 *                     .build())
 *                 .routingType("Default")
 *                 .swaggerSpecifications(SwaggerSpecificationArgs.builder()
 *                     .apiVersions("2020-06-01-preview")
 *                     .swaggerSpecFolderUri("https://github.com/Azure/azure-rest-api-specs/blob/feature/azure/contoso/specification/contoso/resource-manager/Microsoft.SampleRP/")
 *                     .build())
 *                 .build())
 *             .providerNamespace("Microsoft.Contoso")
 *             .resourceType("employees")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:ResourceTypeRegistration employees /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}
 * ```
 * @property properties
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 */
public data class ResourceTypeRegistrationArgs(
    public val properties: Output<ResourceTypeRegistrationPropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.ResourceTypeRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.ResourceTypeRegistrationArgs =
        com.pulumi.azurenative.providerhub.ResourceTypeRegistrationArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeRegistrationArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationArgsBuilder internal constructor() {
    private var properties: Output<ResourceTypeRegistrationPropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("yudfgrcdmkxpiykf")
    public suspend fun properties(`value`: Output<ResourceTypeRegistrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("xdufuldxmwphwxup")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The resource type.
     */
    @JvmName("yxfjenklmvvonsha")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value
     */
    @JvmName("lupuxstpbtuvydhh")
    public suspend fun properties(`value`: ResourceTypeRegistrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wthcwvhjsrvtpuwj")
    public suspend
    fun properties(argument: suspend ResourceTypeRegistrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeRegistrationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("ibldiudcqxdqbexo")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("osgihednrbetyuiq")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): ResourceTypeRegistrationArgs = ResourceTypeRegistrationArgs(
        properties = properties,
        providerNamespace = providerNamespace,
        resourceType = resourceType,
    )
}
