@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.kotlin.outputs.SkuResourceResponseProperties
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.providerhub.kotlin.outputs.SkuResourceResponseProperties.Companion.toKotlin as skuResourceResponsePropertiesToKotlin
import com.pulumi.azurenative.providerhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SkusNestedResourceTypeSecond].
 */
@PulumiTagMarker
public class SkusNestedResourceTypeSecondResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SkusNestedResourceTypeSecondArgs = SkusNestedResourceTypeSecondArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SkusNestedResourceTypeSecondArgsBuilder.() -> Unit) {
        val builder = SkusNestedResourceTypeSecondArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SkusNestedResourceTypeSecond {
        val builtJavaResource =
            com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecond(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SkusNestedResourceTypeSecond(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### Skus_CreateOrUpdateNestedResourceTypeSecond
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var skusNestedResourceTypeSecond = new AzureNative.ProviderHub.SkusNestedResourceTypeSecond("skusNestedResourceTypeSecond", new()
 *     {
 *         NestedResourceTypeFirst = "nestedResourceTypeFirst",
 *         NestedResourceTypeSecond = "nestedResourceTypeSecond",
 *         Properties = new AzureNative.ProviderHub.Inputs.SkuResourcePropertiesArgs
 *         {
 *             SkuSettings = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Kind = "Standard",
 *                     Name = "freeSku",
 *                     Tier = "Tier1",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Costs = new[]
 *                     {
 *                         new AzureNative.ProviderHub.Inputs.SkuCostArgs
 *                         {
 *                             MeterId = "xxx",
 *                         },
 *                     },
 *                     Kind = "Premium",
 *                     Name = "premiumSku",
 *                     Tier = "Tier2",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         ResourceType = "testResourceType",
 *         Sku = "testSku",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewSkusNestedResourceTypeSecond(ctx, "skusNestedResourceTypeSecond", &providerhub.SkusNestedResourceTypeSecondArgs{
 * 			NestedResourceTypeFirst:  pulumi.String("nestedResourceTypeFirst"),
 * 			NestedResourceTypeSecond: pulumi.String("nestedResourceTypeSecond"),
 * 			Properties: &providerhub.SkuResourcePropertiesArgs{
 * 				SkuSettings: providerhub.SkuSettingArray{
 * 					&providerhub.SkuSettingArgs{
 * 						Kind: pulumi.String("Standard"),
 * 						Name: pulumi.String("freeSku"),
 * 						Tier: pulumi.String("Tier1"),
 * 					},
 * 					&providerhub.SkuSettingArgs{
 * 						Costs: providerhub.SkuCostArray{
 * 							&providerhub.SkuCostArgs{
 * 								MeterId: pulumi.String("xxx"),
 * 							},
 * 						},
 * 						Kind: pulumi.String("Premium"),
 * 						Name: pulumi.String("premiumSku"),
 * 						Tier: pulumi.String("Tier2"),
 * 					},
 * 				},
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 			ResourceType:      pulumi.String("testResourceType"),
 * 			Sku:               pulumi.String("testSku"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecond;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecondArgs;
 * import com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var skusNestedResourceTypeSecond = new SkusNestedResourceTypeSecond("skusNestedResourceTypeSecond", SkusNestedResourceTypeSecondArgs.builder()
 *             .nestedResourceTypeFirst("nestedResourceTypeFirst")
 *             .nestedResourceTypeSecond("nestedResourceTypeSecond")
 *             .properties(SkuResourcePropertiesArgs.builder()
 *                 .skuSettings(
 *                     SkuSettingArgs.builder()
 *                         .kind("Standard")
 *                         .name("freeSku")
 *                         .tier("Tier1")
 *                         .build(),
 *                     SkuSettingArgs.builder()
 *                         .costs(SkuCostArgs.builder()
 *                             .meterId("xxx")
 *                             .build())
 *                         .kind("Premium")
 *                         .name("premiumSku")
 *                         .tier("Tier2")
 *                         .build())
 *                 .build())
 *             .providerNamespace("Microsoft.Contoso")
 *             .resourceType("testResourceType")
 *             .sku("testSku")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:SkusNestedResourceTypeSecond Microsoft.Contoso/ /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}
 * ```
 */
public class SkusNestedResourceTypeSecond internal constructor(
    override val javaResource: com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecond,
) : KotlinCustomResource(javaResource, SkusNestedResourceTypeSecondMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<SkuResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResourceResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SkusNestedResourceTypeSecondMapper : ResourceMapper<SkusNestedResourceTypeSecond> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecond::class == javaResource::class

    override fun map(javaResource: Resource): SkusNestedResourceTypeSecond =
        SkusNestedResourceTypeSecond(
            javaResource as
                com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecond,
        )
}

/**
 * @see [SkusNestedResourceTypeSecond].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SkusNestedResourceTypeSecond].
 */
public suspend fun skusNestedResourceTypeSecond(
    name: String,
    block: suspend SkusNestedResourceTypeSecondResourceBuilder.() -> Unit,
):
    SkusNestedResourceTypeSecond {
    val builder = SkusNestedResourceTypeSecondResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SkusNestedResourceTypeSecond].
 * @param name The _unique_ name of the resulting resource.
 */
public fun skusNestedResourceTypeSecond(name: String): SkusNestedResourceTypeSecond {
    val builder = SkusNestedResourceTypeSecondResourceBuilder()
    builder.name(name)
    return builder.build()
}
