@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecondArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.SkuResourcePropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.SkuResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### Skus_CreateOrUpdateNestedResourceTypeSecond
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var skusNestedResourceTypeSecond = new AzureNative.ProviderHub.SkusNestedResourceTypeSecond("skusNestedResourceTypeSecond", new()
 *     {
 *         NestedResourceTypeFirst = "nestedResourceTypeFirst",
 *         NestedResourceTypeSecond = "nestedResourceTypeSecond",
 *         Properties = new AzureNative.ProviderHub.Inputs.SkuResourcePropertiesArgs
 *         {
 *             SkuSettings = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Kind = "Standard",
 *                     Name = "freeSku",
 *                     Tier = "Tier1",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Costs = new[]
 *                     {
 *                         new AzureNative.ProviderHub.Inputs.SkuCostArgs
 *                         {
 *                             MeterId = "xxx",
 *                         },
 *                     },
 *                     Kind = "Premium",
 *                     Name = "premiumSku",
 *                     Tier = "Tier2",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         ResourceType = "testResourceType",
 *         Sku = "testSku",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewSkusNestedResourceTypeSecond(ctx, "skusNestedResourceTypeSecond", &providerhub.SkusNestedResourceTypeSecondArgs{
 * 			NestedResourceTypeFirst:  pulumi.String("nestedResourceTypeFirst"),
 * 			NestedResourceTypeSecond: pulumi.String("nestedResourceTypeSecond"),
 * 			Properties: &providerhub.SkuResourcePropertiesArgs{
 * 				SkuSettings: providerhub.SkuSettingArray{
 * 					&providerhub.SkuSettingArgs{
 * 						Kind: pulumi.String("Standard"),
 * 						Name: pulumi.String("freeSku"),
 * 						Tier: pulumi.String("Tier1"),
 * 					},
 * 					&providerhub.SkuSettingArgs{
 * 						Costs: providerhub.SkuCostArray{
 * 							&providerhub.SkuCostArgs{
 * 								MeterId: pulumi.String("xxx"),
 * 							},
 * 						},
 * 						Kind: pulumi.String("Premium"),
 * 						Name: pulumi.String("premiumSku"),
 * 						Tier: pulumi.String("Tier2"),
 * 					},
 * 				},
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 			ResourceType:      pulumi.String("testResourceType"),
 * 			Sku:               pulumi.String("testSku"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecond;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecondArgs;
 * import com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var skusNestedResourceTypeSecond = new SkusNestedResourceTypeSecond("skusNestedResourceTypeSecond", SkusNestedResourceTypeSecondArgs.builder()
 *             .nestedResourceTypeFirst("nestedResourceTypeFirst")
 *             .nestedResourceTypeSecond("nestedResourceTypeSecond")
 *             .properties(SkuResourcePropertiesArgs.builder()
 *                 .skuSettings(
 *                     SkuSettingArgs.builder()
 *                         .kind("Standard")
 *                         .name("freeSku")
 *                         .tier("Tier1")
 *                         .build(),
 *                     SkuSettingArgs.builder()
 *                         .costs(SkuCostArgs.builder()
 *                             .meterId("xxx")
 *                             .build())
 *                         .kind("Premium")
 *                         .name("premiumSku")
 *                         .tier("Tier2")
 *                         .build())
 *                 .build())
 *             .providerNamespace("Microsoft.Contoso")
 *             .resourceType("testResourceType")
 *             .sku("testSku")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:SkusNestedResourceTypeSecond Microsoft.Contoso/ /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/skus/{sku}
 * ```
 * @property nestedResourceTypeFirst The first child resource type.
 * @property nestedResourceTypeSecond The second child resource type.
 * @property properties
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 * @property sku The SKU.
 */
public data class SkusNestedResourceTypeSecondArgs(
    public val nestedResourceTypeFirst: Output<String>? = null,
    public val nestedResourceTypeSecond: Output<String>? = null,
    public val properties: Output<SkuResourcePropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val sku: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecondArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecondArgs =
        com.pulumi.azurenative.providerhub.SkusNestedResourceTypeSecondArgs.builder()
            .nestedResourceTypeFirst(nestedResourceTypeFirst?.applyValue({ args0 -> args0 }))
            .nestedResourceTypeSecond(nestedResourceTypeSecond?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkusNestedResourceTypeSecondArgs].
 */
@PulumiTagMarker
public class SkusNestedResourceTypeSecondArgsBuilder internal constructor() {
    private var nestedResourceTypeFirst: Output<String>? = null

    private var nestedResourceTypeSecond: Output<String>? = null

    private var properties: Output<SkuResourcePropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var sku: Output<String>? = null

    /**
     * @param value The first child resource type.
     */
    @JvmName("aldepckylghvworj")
    public suspend fun nestedResourceTypeFirst(`value`: Output<String>) {
        this.nestedResourceTypeFirst = value
    }

    /**
     * @param value The second child resource type.
     */
    @JvmName("uvnaevsxjjjosmtt")
    public suspend fun nestedResourceTypeSecond(`value`: Output<String>) {
        this.nestedResourceTypeSecond = value
    }

    /**
     * @param value
     */
    @JvmName("tacgwaiuwjpvgbxf")
    public suspend fun properties(`value`: Output<SkuResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("qufvpinhyquygbdu")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The resource type.
     */
    @JvmName("miwyqsxuxoroodrq")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The SKU.
     */
    @JvmName("imywroooxymgmyxj")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The first child resource type.
     */
    @JvmName("owtjkkbfkfiokwbi")
    public suspend fun nestedResourceTypeFirst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestedResourceTypeFirst = mapped
    }

    /**
     * @param value The second child resource type.
     */
    @JvmName("eirspkwekvaumqbv")
    public suspend fun nestedResourceTypeSecond(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestedResourceTypeSecond = mapped
    }

    /**
     * @param value
     */
    @JvmName("iumhrlhnivlobnkd")
    public suspend fun properties(`value`: SkuResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wdmpkwtyxoctcvrl")
    public suspend fun properties(argument: suspend SkuResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SkuResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("qgwcsuukktilwsci")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("skmlncrcynbbrxmq")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("rnmaphxmtnblrghu")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): SkusNestedResourceTypeSecondArgs = SkusNestedResourceTypeSecondArgs(
        nestedResourceTypeFirst = nestedResourceTypeFirst,
        nestedResourceTypeSecond = nestedResourceTypeSecond,
        properties = properties,
        providerNamespace = providerNamespace,
        resourceType = resourceType,
        sku = sku,
    )
}
