@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin

import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeThirdArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.inputs.SkuResourcePropertiesArgs
import com.pulumi.azurenative.providerhub.kotlin.inputs.SkuResourcePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2021-09-01-preview. Prior API version in Azure Native 1.x: 2020-11-20.
 * ## Example Usage
 * ### Skus_CreateOrUpdateNestedResourceTypeThird
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var skusNestedResourceTypeThird = new AzureNative.ProviderHub.SkusNestedResourceTypeThird("skusNestedResourceTypeThird", new()
 *     {
 *         NestedResourceTypeFirst = "nestedResourceTypeFirst",
 *         NestedResourceTypeSecond = "nestedResourceTypeSecond",
 *         NestedResourceTypeThird = "nestedResourceTypeThird",
 *         Properties = new AzureNative.ProviderHub.Inputs.SkuResourcePropertiesArgs
 *         {
 *             SkuSettings = new[]
 *             {
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Kind = "Standard",
 *                     Name = "freeSku",
 *                     Tier = "Tier1",
 *                 },
 *                 new AzureNative.ProviderHub.Inputs.SkuSettingArgs
 *                 {
 *                     Costs = new[]
 *                     {
 *                         new AzureNative.ProviderHub.Inputs.SkuCostArgs
 *                         {
 *                             MeterId = "xxx",
 *                         },
 *                     },
 *                     Kind = "Premium",
 *                     Name = "premiumSku",
 *                     Tier = "Tier2",
 *                 },
 *             },
 *         },
 *         ProviderNamespace = "Microsoft.Contoso",
 *         ResourceType = "testResourceType",
 *         Sku = "testSku",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/providerhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := providerhub.NewSkusNestedResourceTypeThird(ctx, "skusNestedResourceTypeThird", &providerhub.SkusNestedResourceTypeThirdArgs{
 * 			NestedResourceTypeFirst:  pulumi.String("nestedResourceTypeFirst"),
 * 			NestedResourceTypeSecond: pulumi.String("nestedResourceTypeSecond"),
 * 			NestedResourceTypeThird:  pulumi.String("nestedResourceTypeThird"),
 * 			Properties: &providerhub.SkuResourcePropertiesArgs{
 * 				SkuSettings: providerhub.SkuSettingArray{
 * 					&providerhub.SkuSettingArgs{
 * 						Kind: pulumi.String("Standard"),
 * 						Name: pulumi.String("freeSku"),
 * 						Tier: pulumi.String("Tier1"),
 * 					},
 * 					&providerhub.SkuSettingArgs{
 * 						Costs: providerhub.SkuCostArray{
 * 							&providerhub.SkuCostArgs{
 * 								MeterId: pulumi.String("xxx"),
 * 							},
 * 						},
 * 						Kind: pulumi.String("Premium"),
 * 						Name: pulumi.String("premiumSku"),
 * 						Tier: pulumi.String("Tier2"),
 * 					},
 * 				},
 * 			},
 * 			ProviderNamespace: pulumi.String("Microsoft.Contoso"),
 * 			ResourceType:      pulumi.String("testResourceType"),
 * 			Sku:               pulumi.String("testSku"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeThird;
 * import com.pulumi.azurenative.providerhub.SkusNestedResourceTypeThirdArgs;
 * import com.pulumi.azurenative.providerhub.inputs.SkuResourcePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var skusNestedResourceTypeThird = new SkusNestedResourceTypeThird("skusNestedResourceTypeThird", SkusNestedResourceTypeThirdArgs.builder()
 *             .nestedResourceTypeFirst("nestedResourceTypeFirst")
 *             .nestedResourceTypeSecond("nestedResourceTypeSecond")
 *             .nestedResourceTypeThird("nestedResourceTypeThird")
 *             .properties(SkuResourcePropertiesArgs.builder()
 *                 .skuSettings(
 *                     SkuSettingArgs.builder()
 *                         .kind("Standard")
 *                         .name("freeSku")
 *                         .tier("Tier1")
 *                         .build(),
 *                     SkuSettingArgs.builder()
 *                         .costs(SkuCostArgs.builder()
 *                             .meterId("xxx")
 *                             .build())
 *                         .kind("Premium")
 *                         .name("premiumSku")
 *                         .tier("Tier2")
 *                         .build())
 *                 .build())
 *             .providerNamespace("Microsoft.Contoso")
 *             .resourceType("testResourceType")
 *             .sku("testSku")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:providerhub:SkusNestedResourceTypeThird Microsoft.Contoso/ /subscriptions/{subscriptionId}/providers/Microsoft.ProviderHub/providerRegistrations/{providerNamespace}/resourcetypeRegistrations/{resourceType}/resourcetypeRegistrations/{nestedResourceTypeFirst}/resourcetypeRegistrations/{nestedResourceTypeSecond}/resourcetypeRegistrations/{nestedResourceTypeThird}/skus/{sku}
 * ```
 * @property nestedResourceTypeFirst The first child resource type.
 * @property nestedResourceTypeSecond The second child resource type.
 * @property nestedResourceTypeThird The third child resource type.
 * @property properties
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 * @property sku The SKU.
 */
public data class SkusNestedResourceTypeThirdArgs(
    public val nestedResourceTypeFirst: Output<String>? = null,
    public val nestedResourceTypeSecond: Output<String>? = null,
    public val nestedResourceTypeThird: Output<String>? = null,
    public val properties: Output<SkuResourcePropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val sku: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.SkusNestedResourceTypeThirdArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.SkusNestedResourceTypeThirdArgs =
        com.pulumi.azurenative.providerhub.SkusNestedResourceTypeThirdArgs.builder()
            .nestedResourceTypeFirst(nestedResourceTypeFirst?.applyValue({ args0 -> args0 }))
            .nestedResourceTypeSecond(nestedResourceTypeSecond?.applyValue({ args0 -> args0 }))
            .nestedResourceTypeThird(nestedResourceTypeThird?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkusNestedResourceTypeThirdArgs].
 */
@PulumiTagMarker
public class SkusNestedResourceTypeThirdArgsBuilder internal constructor() {
    private var nestedResourceTypeFirst: Output<String>? = null

    private var nestedResourceTypeSecond: Output<String>? = null

    private var nestedResourceTypeThird: Output<String>? = null

    private var properties: Output<SkuResourcePropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var sku: Output<String>? = null

    /**
     * @param value The first child resource type.
     */
    @JvmName("swdrlcstpocbcjou")
    public suspend fun nestedResourceTypeFirst(`value`: Output<String>) {
        this.nestedResourceTypeFirst = value
    }

    /**
     * @param value The second child resource type.
     */
    @JvmName("fckwomhifpuihldn")
    public suspend fun nestedResourceTypeSecond(`value`: Output<String>) {
        this.nestedResourceTypeSecond = value
    }

    /**
     * @param value The third child resource type.
     */
    @JvmName("edvvmykdtxfjcoyg")
    public suspend fun nestedResourceTypeThird(`value`: Output<String>) {
        this.nestedResourceTypeThird = value
    }

    /**
     * @param value
     */
    @JvmName("bfgxwhoweineexhv")
    public suspend fun properties(`value`: Output<SkuResourcePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("gmjbjrkcytqcbvhh")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The resource type.
     */
    @JvmName("kxqaotgapttalues")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The SKU.
     */
    @JvmName("ytchfblepnpftqbu")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value The first child resource type.
     */
    @JvmName("qscmkwxtyriyxoot")
    public suspend fun nestedResourceTypeFirst(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestedResourceTypeFirst = mapped
    }

    /**
     * @param value The second child resource type.
     */
    @JvmName("gdjialirmtebidfb")
    public suspend fun nestedResourceTypeSecond(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestedResourceTypeSecond = mapped
    }

    /**
     * @param value The third child resource type.
     */
    @JvmName("lumoieqdqtfkefjl")
    public suspend fun nestedResourceTypeThird(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nestedResourceTypeThird = mapped
    }

    /**
     * @param value
     */
    @JvmName("sjyiqfgooevunkdj")
    public suspend fun properties(`value`: SkuResourcePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("llxofepqmobhquif")
    public suspend fun properties(argument: suspend SkuResourcePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SkuResourcePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("wiyxxgcarsolegth")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("bwcjfjuyefsidbfi")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The SKU.
     */
    @JvmName("sktwdscpulfrceay")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    internal fun build(): SkusNestedResourceTypeThirdArgs = SkusNestedResourceTypeThirdArgs(
        nestedResourceTypeFirst = nestedResourceTypeFirst,
        nestedResourceTypeSecond = nestedResourceTypeSecond,
        nestedResourceTypeThird = nestedResourceTypeThird,
        properties = properties,
        providerNamespace = providerNamespace,
        resourceType = resourceType,
        sku = sku,
    )
}
