@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationProviderRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property properties
 */
public data class DefaultRolloutSpecificationProviderRegistrationArgs(
    public val properties: Output<ProviderRegistrationPropertiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationProviderRegistrationArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationProviderRegistrationArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationProviderRegistrationArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DefaultRolloutSpecificationProviderRegistrationArgs].
 */
@PulumiTagMarker
public class DefaultRolloutSpecificationProviderRegistrationArgsBuilder internal constructor() {
    private var properties: Output<ProviderRegistrationPropertiesArgs>? = null

    /**
     * @param value
     */
    @JvmName("utsshiqcuhurhcmx")
    public suspend fun properties(`value`: Output<ProviderRegistrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value
     */
    @JvmName("aagspuvvtfgqskcm")
    public suspend fun properties(`value`: ProviderRegistrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("buyqrkpocaruaibo")
    public suspend
    fun properties(argument: suspend ProviderRegistrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderRegistrationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): DefaultRolloutSpecificationProviderRegistrationArgs =
        DefaultRolloutSpecificationProviderRegistrationArgs(
            properties = properties,
        )
}
