@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetProviderRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 */
public data class GetProviderRegistrationPlainArgs(
    public val providerNamespace: String,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetProviderRegistrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.GetProviderRegistrationPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetProviderRegistrationPlainArgs.builder()
            .providerNamespace(providerNamespace.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProviderRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetProviderRegistrationPlainArgsBuilder internal constructor() {
    private var providerNamespace: String? = null

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("evdgxddlgwkmdajq")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    internal fun build(): GetProviderRegistrationPlainArgs = GetProviderRegistrationPlainArgs(
        providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
    )
}
