@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.LoggingRuleArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.LoggingDetails
import com.pulumi.azurenative.providerhub.kotlin.enums.LoggingDirections
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action
 * @property detailLevel
 * @property direction
 * @property hiddenPropertyPaths
 */
public data class LoggingRuleArgs(
    public val action: Output<String>,
    public val detailLevel: Output<Either<String, LoggingDetails>>,
    public val direction: Output<Either<String, LoggingDirections>>,
    public val hiddenPropertyPaths: Output<LoggingRuleHiddenPropertyPathsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.LoggingRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.LoggingRuleArgs =
        com.pulumi.azurenative.providerhub.inputs.LoggingRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .detailLevel(
                detailLevel.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .direction(
                direction.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hiddenPropertyPaths(
                hiddenPropertyPaths?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LoggingRuleArgs].
 */
@PulumiTagMarker
public class LoggingRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var detailLevel: Output<Either<String, LoggingDetails>>? = null

    private var direction: Output<Either<String, LoggingDirections>>? = null

    private var hiddenPropertyPaths: Output<LoggingRuleHiddenPropertyPathsArgs>? = null

    /**
     * @param value
     */
    @JvmName("efqehrrhqetlxpws")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value
     */
    @JvmName("gociprgjdebuuwir")
    public suspend fun detailLevel(`value`: Output<Either<String, LoggingDetails>>) {
        this.detailLevel = value
    }

    /**
     * @param value
     */
    @JvmName("basyldepfjehpcva")
    public suspend fun direction(`value`: Output<Either<String, LoggingDirections>>) {
        this.direction = value
    }

    /**
     * @param value
     */
    @JvmName("gwufdogxdtxbltwy")
    public suspend fun hiddenPropertyPaths(`value`: Output<LoggingRuleHiddenPropertyPathsArgs>) {
        this.hiddenPropertyPaths = value
    }

    /**
     * @param value
     */
    @JvmName("cpurjtmpdksiatmp")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value
     */
    @JvmName("ihjofwnasrtlapbx")
    public suspend fun detailLevel(`value`: Either<String, LoggingDetails>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.detailLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("adoscevmptwylrhq")
    public fun detailLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoggingDetails>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.detailLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("jqtguvvxpqgogxoy")
    public fun detailLevel(`value`: LoggingDetails) {
        val toBeMapped = Either.ofRight<String, LoggingDetails>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.detailLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("opaxxutcnbmwrxmr")
    public suspend fun direction(`value`: Either<String, LoggingDirections>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value
     */
    @JvmName("xoffncacvcyqyvac")
    public fun direction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LoggingDirections>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value
     */
    @JvmName("bdwfujxqockjjkty")
    public fun direction(`value`: LoggingDirections) {
        val toBeMapped = Either.ofRight<String, LoggingDirections>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.direction = mapped
    }

    /**
     * @param value
     */
    @JvmName("seyccanrrfbicgys")
    public suspend fun hiddenPropertyPaths(`value`: LoggingRuleHiddenPropertyPathsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiddenPropertyPaths = mapped
    }

    /**
     * @param argument
     */
    @JvmName("awwtlhdcaitirudt")
    public suspend
    fun hiddenPropertyPaths(argument: suspend LoggingRuleHiddenPropertyPathsArgsBuilder.() -> Unit) {
        val toBeMapped = LoggingRuleHiddenPropertyPathsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hiddenPropertyPaths = mapped
    }

    internal fun build(): LoggingRuleArgs = LoggingRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        detailLevel = detailLevel ?: throw PulumiNullFieldException("detailLevel"),
        direction = direction ?: throw PulumiNullFieldException("direction"),
        hiddenPropertyPaths = hiddenPropertyPaths,
    )
}
