@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.LoggingRuleHiddenPropertyPathsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hiddenPathsOnRequest
 * @property hiddenPathsOnResponse
 */
public data class LoggingRuleHiddenPropertyPathsArgs(
    public val hiddenPathsOnRequest: Output<List<String>>? = null,
    public val hiddenPathsOnResponse: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.LoggingRuleHiddenPropertyPathsArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.LoggingRuleHiddenPropertyPathsArgs =
        com.pulumi.azurenative.providerhub.inputs.LoggingRuleHiddenPropertyPathsArgs.builder()
            .hiddenPathsOnRequest(hiddenPathsOnRequest?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .hiddenPathsOnResponse(
                hiddenPathsOnResponse?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [LoggingRuleHiddenPropertyPathsArgs].
 */
@PulumiTagMarker
public class LoggingRuleHiddenPropertyPathsArgsBuilder internal constructor() {
    private var hiddenPathsOnRequest: Output<List<String>>? = null

    private var hiddenPathsOnResponse: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("agdlhierxlxgmywy")
    public suspend fun hiddenPathsOnRequest(`value`: Output<List<String>>) {
        this.hiddenPathsOnRequest = value
    }

    @JvmName("jamneeihyrueojwo")
    public suspend fun hiddenPathsOnRequest(vararg values: Output<String>) {
        this.hiddenPathsOnRequest = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("kjemllyngvrqtath")
    public suspend fun hiddenPathsOnRequest(values: List<Output<String>>) {
        this.hiddenPathsOnRequest = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("mxjkwgwkmseopugx")
    public suspend fun hiddenPathsOnResponse(`value`: Output<List<String>>) {
        this.hiddenPathsOnResponse = value
    }

    @JvmName("gysmicowhtmqflxt")
    public suspend fun hiddenPathsOnResponse(vararg values: Output<String>) {
        this.hiddenPathsOnResponse = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fmopqssocbsniuna")
    public suspend fun hiddenPathsOnResponse(values: List<Output<String>>) {
        this.hiddenPathsOnResponse = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ewhyqcvjvjfljgjy")
    public suspend fun hiddenPathsOnRequest(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiddenPathsOnRequest = mapped
    }

    /**
     * @param values
     */
    @JvmName("dqyldpmptuwxofue")
    public suspend fun hiddenPathsOnRequest(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hiddenPathsOnRequest = mapped
    }

    /**
     * @param value
     */
    @JvmName("xkrsnbamdsrpmosf")
    public suspend fun hiddenPathsOnResponse(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hiddenPathsOnResponse = mapped
    }

    /**
     * @param values
     */
    @JvmName("wwlsxvoihgybtqrd")
    public suspend fun hiddenPathsOnResponse(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hiddenPathsOnResponse = mapped
    }

    internal fun build(): LoggingRuleHiddenPropertyPathsArgs = LoggingRuleHiddenPropertyPathsArgs(
        hiddenPathsOnRequest = hiddenPathsOnRequest,
        hiddenPathsOnResponse = hiddenPathsOnResponse,
    )
}
