@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.NotificationRegistrationPropertiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.MessageScope
import com.pulumi.azurenative.providerhub.kotlin.enums.NotificationMode
import com.pulumi.azurenative.providerhub.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property includedEvents
 * @property messageScope
 * @property notificationEndpoints
 * @property notificationMode
 * @property provisioningState The provisioned state of the resource.
 */
public data class NotificationRegistrationPropertiesArgs(
    public val includedEvents: Output<List<String>>? = null,
    public val messageScope: Output<Either<String, MessageScope>>? = null,
    public val notificationEndpoints: Output<List<NotificationEndpointArgs>>? = null,
    public val notificationMode: Output<Either<String, NotificationMode>>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.NotificationRegistrationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.NotificationRegistrationPropertiesArgs =
        com.pulumi.azurenative.providerhub.inputs.NotificationRegistrationPropertiesArgs.builder()
            .includedEvents(includedEvents?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .messageScope(
                messageScope?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .notificationEndpoints(
                notificationEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .notificationMode(
                notificationMode?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [NotificationRegistrationPropertiesArgs].
 */
@PulumiTagMarker
public class NotificationRegistrationPropertiesArgsBuilder internal constructor() {
    private var includedEvents: Output<List<String>>? = null

    private var messageScope: Output<Either<String, MessageScope>>? = null

    private var notificationEndpoints: Output<List<NotificationEndpointArgs>>? = null

    private var notificationMode: Output<Either<String, NotificationMode>>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    /**
     * @param value
     */
    @JvmName("rgjpirtecldcloep")
    public suspend fun includedEvents(`value`: Output<List<String>>) {
        this.includedEvents = value
    }

    @JvmName("sypkcwddmwuuuysm")
    public suspend fun includedEvents(vararg values: Output<String>) {
        this.includedEvents = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qfnhlvqcttgskuvb")
    public suspend fun includedEvents(values: List<Output<String>>) {
        this.includedEvents = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lxbbtbrkkeqmmcpc")
    public suspend fun messageScope(`value`: Output<Either<String, MessageScope>>) {
        this.messageScope = value
    }

    /**
     * @param value
     */
    @JvmName("lksrddtrlgehaylx")
    public suspend fun notificationEndpoints(`value`: Output<List<NotificationEndpointArgs>>) {
        this.notificationEndpoints = value
    }

    @JvmName("skwusuanrbjsuidu")
    public suspend fun notificationEndpoints(vararg values: Output<NotificationEndpointArgs>) {
        this.notificationEndpoints = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vvuyqlihbssjdkpc")
    public suspend fun notificationEndpoints(values: List<Output<NotificationEndpointArgs>>) {
        this.notificationEndpoints = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xardgrmnghqjfudp")
    public suspend fun notificationMode(`value`: Output<Either<String, NotificationMode>>) {
        this.notificationMode = value
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("migxwhlnwvcokxmm")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value
     */
    @JvmName("pgukupwtxwkrlswi")
    public suspend fun includedEvents(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedEvents = mapped
    }

    /**
     * @param values
     */
    @JvmName("xkvwugwxhmjjdbxc")
    public suspend fun includedEvents(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedEvents = mapped
    }

    /**
     * @param value
     */
    @JvmName("ofajfhksnvhuqsyw")
    public suspend fun messageScope(`value`: Either<String, MessageScope>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageScope = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmppccvxhsasdnem")
    public fun messageScope(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MessageScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageScope = mapped
    }

    /**
     * @param value
     */
    @JvmName("gpypusxtarefitfh")
    public fun messageScope(`value`: MessageScope) {
        val toBeMapped = Either.ofRight<String, MessageScope>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageScope = mapped
    }

    /**
     * @param value
     */
    @JvmName("ytjkthxshypmoqiq")
    public suspend fun notificationEndpoints(`value`: List<NotificationEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationEndpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("pclbpcyvbxrcvwtk")
    public suspend
    fun notificationEndpoints(argument: List<suspend NotificationEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NotificationEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationEndpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tpydsbypmjfhimtm")
    public suspend fun notificationEndpoints(
        vararg
        argument: suspend NotificationEndpointArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NotificationEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationEndpoints = mapped
    }

    /**
     * @param argument
     */
    @JvmName("npgtrnuyfaofmxct")
    public suspend
    fun notificationEndpoints(argument: suspend NotificationEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NotificationEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notificationEndpoints = mapped
    }

    /**
     * @param values
     */
    @JvmName("jbghbiwjowlcpsng")
    public suspend fun notificationEndpoints(vararg values: NotificationEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationEndpoints = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlxwhuhvettetfdp")
    public suspend fun notificationMode(`value`: Either<String, NotificationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("gbjumchdvjsaxlfo")
    public fun notificationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotificationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewojaglgbkcncqlm")
    public fun notificationMode(`value`: NotificationMode) {
        val toBeMapped = Either.ofRight<String, NotificationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationMode = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("pdnoienfaaajjnrj")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("jufimqftauwrqdhr")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("iqxoduyndextcssq")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): NotificationRegistrationPropertiesArgs =
        NotificationRegistrationPropertiesArgs(
            includedEvents = includedEvents,
            messageScope = messageScope,
            notificationEndpoints = notificationEndpoints,
            notificationMode = notificationMode,
            provisioningState = provisioningState,
        )
}
