@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataThirdPartyProviderAuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property authorizations
 * @property managedByTenantId
 */
public data class ProviderHubMetadataThirdPartyProviderAuthorizationArgs(
    public val authorizations: Output<List<LightHouseAuthorizationArgs>>? = null,
    public val managedByTenantId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataThirdPartyProviderAuthorizationArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataThirdPartyProviderAuthorizationArgs =
        com.pulumi.azurenative.providerhub.inputs.ProviderHubMetadataThirdPartyProviderAuthorizationArgs.builder()
            .authorizations(
                authorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .managedByTenantId(managedByTenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProviderHubMetadataThirdPartyProviderAuthorizationArgs].
 */
@PulumiTagMarker
public class ProviderHubMetadataThirdPartyProviderAuthorizationArgsBuilder internal constructor() {
    private var authorizations: Output<List<LightHouseAuthorizationArgs>>? = null

    private var managedByTenantId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("bmxsaynqydbegcwi")
    public suspend fun authorizations(`value`: Output<List<LightHouseAuthorizationArgs>>) {
        this.authorizations = value
    }

    @JvmName("ljqekwfwaantdwaw")
    public suspend fun authorizations(vararg values: Output<LightHouseAuthorizationArgs>) {
        this.authorizations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("elykqgcgexnxeulw")
    public suspend fun authorizations(values: List<Output<LightHouseAuthorizationArgs>>) {
        this.authorizations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xogmytlopyehlevc")
    public suspend fun managedByTenantId(`value`: Output<String>) {
        this.managedByTenantId = value
    }

    /**
     * @param value
     */
    @JvmName("woehkcyimoabhquw")
    public suspend fun authorizations(`value`: List<LightHouseAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kbjhrybbhxwgavmt")
    public suspend
    fun authorizations(argument: List<suspend LightHouseAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LightHouseAuthorizationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("vsbegjvioeeaadnn")
    public suspend fun authorizations(
        vararg
        argument: suspend LightHouseAuthorizationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LightHouseAuthorizationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tlspfgmwoxbulhof")
    public suspend
    fun authorizations(argument: suspend LightHouseAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LightHouseAuthorizationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authorizations = mapped
    }

    /**
     * @param values
     */
    @JvmName("hercnlvqdawdmvhr")
    public suspend fun authorizations(vararg values: LightHouseAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizations = mapped
    }

    /**
     * @param value
     */
    @JvmName("stjwkjeeoxyctwye")
    public suspend fun managedByTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedByTenantId = mapped
    }

    internal fun build(): ProviderHubMetadataThirdPartyProviderAuthorizationArgs =
        ProviderHubMetadataThirdPartyProviderAuthorizationArgs(
            authorizations = authorizations,
            managedByTenantId = managedByTenantId,
        )
}
