@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ProvisioningState
import com.pulumi.azurenative.providerhub.kotlin.enums.ResourceProviderType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property featuresRule
 * @property management
 * @property metadata
 * @property namespace
 * @property providerAuthentication
 * @property providerAuthorizations
 * @property providerHubMetadata
 * @property providerType
 * @property providerVersion
 * @property provisioningState The provisioned state of the resource.
 * @property requestHeaderOptions
 * @property requiredFeatures
 * @property subscriptionLifecycleNotificationSpecifications
 * @property templateDeploymentOptions
 */
public data class ProviderRegistrationPropertiesArgs(
    public val capabilities: Output<List<ResourceProviderCapabilitiesArgs>>? = null,
    public val featuresRule: Output<ResourceProviderManifestPropertiesFeaturesRuleArgs>? = null,
    public val management: Output<ResourceProviderManifestPropertiesManagementArgs>? = null,
    public val metadata: Output<Any>? = null,
    public val namespace: Output<String>? = null,
    public val providerAuthentication:
    Output<ResourceProviderManifestPropertiesProviderAuthenticationArgs>? = null,
    public val providerAuthorizations: Output<List<ResourceProviderAuthorizationArgs>>? = null,
    public val providerHubMetadata: Output<ProviderRegistrationPropertiesProviderHubMetadataArgs>? =
        null,
    public val providerType: Output<Either<String, ResourceProviderType>>? = null,
    public val providerVersion: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val requestHeaderOptions:
    Output<ResourceProviderManifestPropertiesRequestHeaderOptionsArgs>? = null,
    public val requiredFeatures: Output<List<String>>? = null,
    public val subscriptionLifecycleNotificationSpecifications:
    Output<ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>? =
        null,
    public val templateDeploymentOptions:
    Output<ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesArgs =
        com.pulumi.azurenative.providerhub.inputs.ProviderRegistrationPropertiesArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .featuresRule(featuresRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .management(management?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .providerAuthentication(
                providerAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .providerAuthorizations(
                providerAuthorizations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .providerHubMetadata(
                providerHubMetadata?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .providerType(
                providerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .providerVersion(providerVersion?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .requestHeaderOptions(
                requestHeaderOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subscriptionLifecycleNotificationSpecifications(
                subscriptionLifecycleNotificationSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .templateDeploymentOptions(
                templateDeploymentOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ProviderRegistrationPropertiesArgs].
 */
@PulumiTagMarker
public class ProviderRegistrationPropertiesArgsBuilder internal constructor() {
    private var capabilities: Output<List<ResourceProviderCapabilitiesArgs>>? = null

    private var featuresRule: Output<ResourceProviderManifestPropertiesFeaturesRuleArgs>? = null

    private var management: Output<ResourceProviderManifestPropertiesManagementArgs>? = null

    private var metadata: Output<Any>? = null

    private var namespace: Output<String>? = null

    private var providerAuthentication:
        Output<ResourceProviderManifestPropertiesProviderAuthenticationArgs>? = null

    private var providerAuthorizations: Output<List<ResourceProviderAuthorizationArgs>>? = null

    private var providerHubMetadata: Output<ProviderRegistrationPropertiesProviderHubMetadataArgs>? =
        null

    private var providerType: Output<Either<String, ResourceProviderType>>? = null

    private var providerVersion: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var requestHeaderOptions:
        Output<ResourceProviderManifestPropertiesRequestHeaderOptionsArgs>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var subscriptionLifecycleNotificationSpecifications:
        Output<ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>? =
        null

    private var templateDeploymentOptions:
        Output<ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs>? = null

    /**
     * @param value
     */
    @JvmName("nctehsnayoakumpw")
    public suspend fun capabilities(`value`: Output<List<ResourceProviderCapabilitiesArgs>>) {
        this.capabilities = value
    }

    @JvmName("yogxbopnbrmhxgwx")
    public suspend fun capabilities(vararg values: Output<ResourceProviderCapabilitiesArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tyruqdrqoktxajkj")
    public suspend fun capabilities(values: List<Output<ResourceProviderCapabilitiesArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kfviijoetlvisqmh")
    public suspend
    fun featuresRule(`value`: Output<ResourceProviderManifestPropertiesFeaturesRuleArgs>) {
        this.featuresRule = value
    }

    /**
     * @param value
     */
    @JvmName("yoxvhxefpwujjljm")
    public suspend fun management(`value`: Output<ResourceProviderManifestPropertiesManagementArgs>) {
        this.management = value
    }

    /**
     * @param value
     */
    @JvmName("uxjbxglioqxkbmny")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value
     */
    @JvmName("smdirvpnvrdnoisi")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value
     */
    @JvmName("erauaxuliayoqcqo")
    public suspend
    fun providerAuthentication(`value`: Output<ResourceProviderManifestPropertiesProviderAuthenticationArgs>) {
        this.providerAuthentication = value
    }

    /**
     * @param value
     */
    @JvmName("aebagjckfetabika")
    public suspend
    fun providerAuthorizations(`value`: Output<List<ResourceProviderAuthorizationArgs>>) {
        this.providerAuthorizations = value
    }

    @JvmName("vnidmwkybuohgqrg")
    public suspend fun providerAuthorizations(
        vararg
        values: Output<ResourceProviderAuthorizationArgs>,
    ) {
        this.providerAuthorizations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vssufduwgjgisarr")
    public suspend
    fun providerAuthorizations(values: List<Output<ResourceProviderAuthorizationArgs>>) {
        this.providerAuthorizations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("kpbjhripsvviomxu")
    public suspend
    fun providerHubMetadata(`value`: Output<ProviderRegistrationPropertiesProviderHubMetadataArgs>) {
        this.providerHubMetadata = value
    }

    /**
     * @param value
     */
    @JvmName("sfsrpvwqjlenopri")
    public suspend fun providerType(`value`: Output<Either<String, ResourceProviderType>>) {
        this.providerType = value
    }

    /**
     * @param value
     */
    @JvmName("wiuyfpogayjkeiej")
    public suspend fun providerVersion(`value`: Output<String>) {
        this.providerVersion = value
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("brhfhanaywegvxsd")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value
     */
    @JvmName("iksvnwiuueggflfw")
    public suspend
    fun requestHeaderOptions(`value`: Output<ResourceProviderManifestPropertiesRequestHeaderOptionsArgs>) {
        this.requestHeaderOptions = value
    }

    /**
     * @param value
     */
    @JvmName("ulamoepufuqhkjhh")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("nulwktdsynnderva")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fixhduxwcklomrur")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("awkkpcahkxawuvmt")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(`value`: Output<ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs>) {
        this.subscriptionLifecycleNotificationSpecifications = value
    }

    /**
     * @param value
     */
    @JvmName("oyvlftfnqagpdibd")
    public suspend
    fun templateDeploymentOptions(`value`: Output<ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs>) {
        this.templateDeploymentOptions = value
    }

    /**
     * @param value
     */
    @JvmName("qudikaynwtewyuss")
    public suspend fun capabilities(`value`: List<ResourceProviderCapabilitiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("aiiiaxewoqxhbdnt")
    public suspend
    fun capabilities(argument: List<suspend ResourceProviderCapabilitiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceProviderCapabilitiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dijkpgmaogyofmop")
    public suspend fun capabilities(
        vararg
        argument: suspend ResourceProviderCapabilitiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceProviderCapabilitiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ffpbpijlrgqcedbp")
    public suspend
    fun capabilities(argument: suspend ResourceProviderCapabilitiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResourceProviderCapabilitiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("hkgqoekljgpleiub")
    public suspend fun capabilities(vararg values: ResourceProviderCapabilitiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("ipiuynkhfuxnovfu")
    public suspend fun featuresRule(`value`: ResourceProviderManifestPropertiesFeaturesRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kbajmjspdwwhrmmt")
    public suspend
    fun featuresRule(argument: suspend ResourceProviderManifestPropertiesFeaturesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceProviderManifestPropertiesFeaturesRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featuresRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("crrgwjxcetrjvhrw")
    public suspend fun management(`value`: ResourceProviderManifestPropertiesManagementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.management = mapped
    }

    /**
     * @param argument
     */
    @JvmName("eeabxodroaxmdwje")
    public suspend
    fun management(argument: suspend ResourceProviderManifestPropertiesManagementArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceProviderManifestPropertiesManagementArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.management = mapped
    }

    /**
     * @param value
     */
    @JvmName("isjjxjxkjohmbgia")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value
     */
    @JvmName("teudkescvjavmvwg")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value
     */
    @JvmName("rftbeexdexwgcqxm")
    public suspend
    fun providerAuthentication(`value`: ResourceProviderManifestPropertiesProviderAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerAuthentication = mapped
    }

    /**
     * @param argument
     */
    @JvmName("byofftmxnpgatmrs")
    public suspend
    fun providerAuthentication(argument: suspend ResourceProviderManifestPropertiesProviderAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceProviderManifestPropertiesProviderAuthenticationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.providerAuthentication = mapped
    }

    /**
     * @param value
     */
    @JvmName("optidycmqrklpwgy")
    public suspend fun providerAuthorizations(`value`: List<ResourceProviderAuthorizationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerAuthorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tgmwlnbmbqyvvrwe")
    public suspend
    fun providerAuthorizations(argument: List<suspend ResourceProviderAuthorizationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceProviderAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.providerAuthorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("keeeycsfaaqwpcvh")
    public suspend fun providerAuthorizations(
        vararg
        argument: suspend ResourceProviderAuthorizationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceProviderAuthorizationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.providerAuthorizations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gakoujanjrhwmhcw")
    public suspend
    fun providerAuthorizations(argument: suspend ResourceProviderAuthorizationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ResourceProviderAuthorizationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.providerAuthorizations = mapped
    }

    /**
     * @param values
     */
    @JvmName("yhemxalvlupcscnh")
    public suspend fun providerAuthorizations(vararg values: ResourceProviderAuthorizationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerAuthorizations = mapped
    }

    /**
     * @param value
     */
    @JvmName("bhqklcytcnirbmrl")
    public suspend
    fun providerHubMetadata(`value`: ProviderRegistrationPropertiesProviderHubMetadataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerHubMetadata = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ilqleppypxcvyfqv")
    public suspend
    fun providerHubMetadata(argument: suspend ProviderRegistrationPropertiesProviderHubMetadataArgsBuilder.() -> Unit) {
        val toBeMapped = ProviderRegistrationPropertiesProviderHubMetadataArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.providerHubMetadata = mapped
    }

    /**
     * @param value
     */
    @JvmName("kgvflmnnjjiqiyih")
    public suspend fun providerType(`value`: Either<String, ResourceProviderType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value
     */
    @JvmName("ujphmxakktlofpfu")
    public fun providerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value
     */
    @JvmName("iexeuxdvpaqjrlmg")
    public fun providerType(`value`: ResourceProviderType) {
        val toBeMapped = Either.ofRight<String, ResourceProviderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value
     */
    @JvmName("swiypebqscqidgpy")
    public suspend fun providerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerVersion = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("syebwmhpjggvbmde")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("cgnaxuslvigjaxku")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The provisioned state of the resource.
     */
    @JvmName("irggrlkfghplgfpi")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value
     */
    @JvmName("vcxowwnpdulkeoyn")
    public suspend
    fun requestHeaderOptions(`value`: ResourceProviderManifestPropertiesRequestHeaderOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaderOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sqailffjafajdgup")
    public suspend
    fun requestHeaderOptions(argument: suspend ResourceProviderManifestPropertiesRequestHeaderOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceProviderManifestPropertiesRequestHeaderOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.requestHeaderOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("okiqptmpfsmjugsf")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("hbwkwvjegptulmlo")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("xwtgsmxeboxpcaak")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(`value`: ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionLifecycleNotificationSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("paqaotetflmykedu")
    public suspend
    fun subscriptionLifecycleNotificationSpecifications(argument: suspend ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ProviderRegistrationPropertiesSubscriptionLifecycleNotificationSpecificationsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.subscriptionLifecycleNotificationSpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("epnpyxeukivtjmgu")
    public suspend
    fun templateDeploymentOptions(`value`: ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateDeploymentOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wmslbcqhjplkaeeh")
    public suspend
    fun templateDeploymentOptions(argument: suspend ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.templateDeploymentOptions = mapped
    }

    internal fun build(): ProviderRegistrationPropertiesArgs = ProviderRegistrationPropertiesArgs(
        capabilities = capabilities,
        featuresRule = featuresRule,
        management = management,
        metadata = metadata,
        namespace = namespace,
        providerAuthentication = providerAuthentication,
        providerAuthorizations = providerAuthorizations,
        providerHubMetadata = providerHubMetadata,
        providerType = providerType,
        providerVersion = providerVersion,
        provisioningState = provisioningState,
        requestHeaderOptions = requestHeaderOptions,
        requiredFeatures = requiredFeatures,
        subscriptionLifecycleNotificationSpecifications = subscriptionLifecycleNotificationSpecifications,
        templateDeploymentOptions = templateDeploymentOptions,
    )
}
