@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesFeaturesRuleArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.FeaturesPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property requiredFeaturesPolicy
 */
public data class ResourceProviderManifestPropertiesFeaturesRuleArgs(
    public val requiredFeaturesPolicy: Output<Either<String, FeaturesPolicy>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesFeaturesRuleArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesFeaturesRuleArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesFeaturesRuleArgs.builder()
            .requiredFeaturesPolicy(
                requiredFeaturesPolicy.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [ResourceProviderManifestPropertiesFeaturesRuleArgs].
 */
@PulumiTagMarker
public class ResourceProviderManifestPropertiesFeaturesRuleArgsBuilder internal constructor() {
    private var requiredFeaturesPolicy: Output<Either<String, FeaturesPolicy>>? = null

    /**
     * @param value
     */
    @JvmName("lwelfnjjrpxrbttt")
    public suspend fun requiredFeaturesPolicy(`value`: Output<Either<String, FeaturesPolicy>>) {
        this.requiredFeaturesPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("chbbjjfeklmcvxds")
    public suspend fun requiredFeaturesPolicy(`value`: Either<String, FeaturesPolicy>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeaturesPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmdtnxkcivrohcmn")
    public fun requiredFeaturesPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FeaturesPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeaturesPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("dliaumyrqxheybar")
    public fun requiredFeaturesPolicy(`value`: FeaturesPolicy) {
        val toBeMapped = Either.ofRight<String, FeaturesPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeaturesPolicy = mapped
    }

    internal fun build(): ResourceProviderManifestPropertiesFeaturesRuleArgs =
        ResourceProviderManifestPropertiesFeaturesRuleArgs(
            requiredFeaturesPolicy = requiredFeaturesPolicy ?: throw
                PulumiNullFieldException("requiredFeaturesPolicy"),
        )
}
