@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesRequestHeaderOptionsArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.OptInHeaderType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optInHeaders
 */
public data class ResourceProviderManifestPropertiesRequestHeaderOptionsArgs(
    public val optInHeaders: Output<Either<String, OptInHeaderType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesRequestHeaderOptionsArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesRequestHeaderOptionsArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesRequestHeaderOptionsArgs.builder()
            .optInHeaders(
                optInHeaders?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceProviderManifestPropertiesRequestHeaderOptionsArgs].
 */
@PulumiTagMarker
public class ResourceProviderManifestPropertiesRequestHeaderOptionsArgsBuilder internal
constructor() {
    private var optInHeaders: Output<Either<String, OptInHeaderType>>? = null

    /**
     * @param value
     */
    @JvmName("lqcvbavolxyturaa")
    public suspend fun optInHeaders(`value`: Output<Either<String, OptInHeaderType>>) {
        this.optInHeaders = value
    }

    /**
     * @param value
     */
    @JvmName("xkmutkwawivgohem")
    public suspend fun optInHeaders(`value`: Either<String, OptInHeaderType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optInHeaders = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgvmxqteoercjpuv")
    public fun optInHeaders(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OptInHeaderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optInHeaders = mapped
    }

    /**
     * @param value
     */
    @JvmName("bmydwitcuxdihstg")
    public fun optInHeaders(`value`: OptInHeaderType) {
        val toBeMapped = Either.ofRight<String, OptInHeaderType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.optInHeaders = mapped
    }

    internal fun build(): ResourceProviderManifestPropertiesRequestHeaderOptionsArgs =
        ResourceProviderManifestPropertiesRequestHeaderOptionsArgs(
            optInHeaders = optInHeaders,
        )
}
