@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.EndpointType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property apiVersions
 * @property enabled
 * @property endpointType
 * @property extensions
 * @property featuresRule
 * @property locations
 * @property requiredFeatures
 * @property timeout
 */
public data class ResourceTypeEndpointArgs(
    public val apiVersions: Output<List<String>>? = null,
    public val enabled: Output<Boolean>? = null,
    public val endpointType: Output<Either<String, EndpointType>>? = null,
    public val extensions: Output<List<ResourceTypeExtensionArgs>>? = null,
    public val featuresRule: Output<ResourceTypeEndpointFeaturesRuleArgs>? = null,
    public val locations: Output<List<String>>? = null,
    public val requiredFeatures: Output<List<String>>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeEndpointArgs.builder()
            .apiVersions(apiVersions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endpointType(
                endpointType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extensions(
                extensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .featuresRule(featuresRule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeEndpointArgs].
 */
@PulumiTagMarker
public class ResourceTypeEndpointArgsBuilder internal constructor() {
    private var apiVersions: Output<List<String>>? = null

    private var enabled: Output<Boolean>? = null

    private var endpointType: Output<Either<String, EndpointType>>? = null

    private var extensions: Output<List<ResourceTypeExtensionArgs>>? = null

    private var featuresRule: Output<ResourceTypeEndpointFeaturesRuleArgs>? = null

    private var locations: Output<List<String>>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("alqwdaynkhvcwxpm")
    public suspend fun apiVersions(`value`: Output<List<String>>) {
        this.apiVersions = value
    }

    @JvmName("lobmsrqccvyaqccm")
    public suspend fun apiVersions(vararg values: Output<String>) {
        this.apiVersions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("vcxoignunuvwwcxq")
    public suspend fun apiVersions(values: List<Output<String>>) {
        this.apiVersions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("rqffinfrqaermqsj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value
     */
    @JvmName("nmvwncdmguxvohro")
    public suspend fun endpointType(`value`: Output<Either<String, EndpointType>>) {
        this.endpointType = value
    }

    /**
     * @param value
     */
    @JvmName("mmrxqplnvxeyaunw")
    public suspend fun extensions(`value`: Output<List<ResourceTypeExtensionArgs>>) {
        this.extensions = value
    }

    @JvmName("ivndkosvdwkyoyeh")
    public suspend fun extensions(vararg values: Output<ResourceTypeExtensionArgs>) {
        this.extensions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("qswlxuughioliair")
    public suspend fun extensions(values: List<Output<ResourceTypeExtensionArgs>>) {
        this.extensions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("fjgssgeugkjyvasv")
    public suspend fun featuresRule(`value`: Output<ResourceTypeEndpointFeaturesRuleArgs>) {
        this.featuresRule = value
    }

    /**
     * @param value
     */
    @JvmName("qrtcuuoqmckoekyd")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("mdaqujwrowrekahv")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("hbsjwvwljdlincav")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("xrimuctknxwfoqmv")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("iochxyjqrjtviikd")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("xufvelmlxpehwrtf")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("graprjfyvmivsthh")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value
     */
    @JvmName("pyatgoiphfmxuxox")
    public suspend fun apiVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param values
     */
    @JvmName("moihcrtksntewvlt")
    public suspend fun apiVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiVersions = mapped
    }

    /**
     * @param value
     */
    @JvmName("sntsygujwavdwnme")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("extsnhojtgcowqvr")
    public suspend fun endpointType(`value`: Either<String, EndpointType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("kniockloiinhkncb")
    public fun endpointType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("skupjonmsaboycoh")
    public fun endpointType(`value`: EndpointType) {
        val toBeMapped = Either.ofRight<String, EndpointType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value
     */
    @JvmName("uoyueoexwhcryvjk")
    public suspend fun extensions(`value`: List<ResourceTypeExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mbghxnweumiqqyja")
    public suspend
    fun extensions(argument: List<suspend ResourceTypeExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceTypeExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ampctkjogirlukfw")
    public suspend fun extensions(
        vararg
        argument: suspend ResourceTypeExtensionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceTypeExtensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qukgngtnakpmmkas")
    public suspend fun extensions(argument: suspend ResourceTypeExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceTypeExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.extensions = mapped
    }

    /**
     * @param values
     */
    @JvmName("ykbddxtsshkleepn")
    public suspend fun extensions(vararg values: ResourceTypeExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensions = mapped
    }

    /**
     * @param value
     */
    @JvmName("ijlphwhpjssvxrrv")
    public suspend fun featuresRule(`value`: ResourceTypeEndpointFeaturesRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featuresRule = mapped
    }

    /**
     * @param argument
     */
    @JvmName("klrosohlwsgvbwrw")
    public suspend
    fun featuresRule(argument: suspend ResourceTypeEndpointFeaturesRuleArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceTypeEndpointFeaturesRuleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.featuresRule = mapped
    }

    /**
     * @param value
     */
    @JvmName("hvpijmrrsfvrinuf")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("myungqimbdrdmeuo")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjnabqpvhnjpvbjn")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("ihieurjirbnwpnnp")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("loslckbvoevnondi")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ResourceTypeEndpointArgs = ResourceTypeEndpointArgs(
        apiVersions = apiVersions,
        enabled = enabled,
        endpointType = endpointType,
        extensions = extensions,
        featuresRule = featuresRule,
        locations = locations,
        requiredFeatures = requiredFeatures,
        timeout = timeout,
    )
}
