@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionOptionsResourceCreationBeginArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ExtensionOptionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property request
 * @property response
 */
public data class ResourceTypeExtensionOptionsResourceCreationBeginArgs(
    public val request: Output<List<Either<String, ExtensionOptionType>>>? = null,
    public val response: Output<List<Either<String, ExtensionOptionType>>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionOptionsResourceCreationBeginArgs> {
    override fun toJava():
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionOptionsResourceCreationBeginArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionOptionsResourceCreationBeginArgs.builder()
            .request(
                request?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .response(
                response?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceTypeExtensionOptionsResourceCreationBeginArgs].
 */
@PulumiTagMarker
public class ResourceTypeExtensionOptionsResourceCreationBeginArgsBuilder internal constructor() {
    private var request: Output<List<Either<String, ExtensionOptionType>>>? = null

    private var response: Output<List<Either<String, ExtensionOptionType>>>? = null

    /**
     * @param value
     */
    @JvmName("uvjlnxibfqcpviwc")
    public suspend fun request(`value`: Output<List<Either<String, ExtensionOptionType>>>) {
        this.request = value
    }

    @JvmName("udwfwirphivxnmmt")
    public suspend fun request(vararg values: Output<Either<String, ExtensionOptionType>>) {
        this.request = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pprxvlrgpnbegqtj")
    public suspend fun request(values: List<Output<Either<String, ExtensionOptionType>>>) {
        this.request = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ghjrcbpworijkuuo")
    public suspend fun response(`value`: Output<List<Either<String, ExtensionOptionType>>>) {
        this.response = value
    }

    @JvmName("msjtquacusabrjnq")
    public suspend fun response(vararg values: Output<Either<String, ExtensionOptionType>>) {
        this.response = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("uxcqgwlawbqynkmr")
    public suspend fun response(values: List<Output<Either<String, ExtensionOptionType>>>) {
        this.response = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("evkfbyefxktfpenc")
    public suspend fun request(`value`: List<Either<String, ExtensionOptionType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param values
     */
    @JvmName("raprlijikdxfcnbt")
    public suspend fun request(vararg values: Either<String, ExtensionOptionType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param value
     */
    @JvmName("gssvpcyrntrmpwvc")
    public suspend fun response(`value`: List<Either<String, ExtensionOptionType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param values
     */
    @JvmName("dnmvpiedavssrilb")
    public suspend fun response(vararg values: Either<String, ExtensionOptionType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.response = mapped
    }

    internal fun build(): ResourceTypeExtensionOptionsResourceCreationBeginArgs =
        ResourceTypeExtensionOptionsResourceCreationBeginArgs(
            request = request,
            response = response,
        )
}
